/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.commands.host.player.death;

import eu.scorpionltd.annotations.commands.Command;
import eu.scorpionltd.annotations.commands.CommandArgs;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.permissions.Permissions;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.tasks.TimerManager;
import eu.scorpionltd.uhc.util.player.PlayerUtil;
import eu.scorpionltd.uhc.util.server.enums.Status;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ReviveCommand {
    @Command(name="revive", description="Revive a player", usage="Usage: /revive <Player>")
    public void onDrainCommand(CommandArgs args) {
        if (!Status.getCurrentStatus().isStart()) {
            return;
        }
        if (!args.isPlayer()) {
            return;
        }
        Player p = args.getPlayer();
        if (!Permissions.REVIVE_CMD.hasPerm(p)) {
            MEnum.NO_PERMISSION.sendTo(p, new Object[0]);
            return;
        }
        if (args.getArgs().length != 1) {
            MEnum.REVIVE_USE.sendTo(p, new Object[0]);
            return;
        }
        Player target = Bukkit.getPlayer((String)args.getArgs(0));
        if (target == null) {
            MEnum.NO_CONNECTED.sendTo(p, new Object[0]);
            return;
        }
        if (!TimerManager.hasTimerPVP() && !ConfigFile.SPECS_REVIVE_AFTER_PVP.getBoolean()) {
            MEnum.REVIVE_BLOCKED_AFTER_PVP.sendTo(p, new Object[0]);
            return;
        }
        MEnum.REVIVE_PLAYER.sendTo(p, target.getName());
        PlayerUtil.revivePlayer(target);
    }
}

