/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.commands.host.player;

import eu.scorpionltd.annotations.commands.Command;
import eu.scorpionltd.annotations.commands.CommandArgs;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.players.permissions.Permissions;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import eu.scorpionltd.uhc.util.player.PlayerUtil;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class NearCommand {
    @Command(name="near", description="See players around a player", usage="Usage: /near <Player>")
    public void onCommand(CommandArgs args) {
        if (!(args.getSender() instanceof Player)) {
            return;
        }
        Player p = args.getPlayer();
        UHCPlayer up = UHCPlayerManager.getPlayer(p);
        if (!Permissions.NEAR_CMD.hasPerm(p)) {
            MEnum.NO_PERMISSION.sendTo(p, new Object[0]);
            return;
        }
        if (args.getArgs().length > 1) {
            MEnum.NEAR_USE.sendTo(p, new Object[0]);
            return;
        }
        if (args.getArgs().length == 0) {
            this.sendNearPlayers(p, up);
            return;
        }
        Player target = Bukkit.getPlayer((String)args.getArgs(0));
        if (target == null || !target.isOnline()) {
            MEnum.NO_CONNECTED.sendTo(p, new Object[0]);
            return;
        }
        this.sendNearPlayers(p, UHCPlayerManager.getPlayer(target));
    }

    public void sendNearPlayers(Player sender, UHCPlayer target) {
        List<Player> players = PlayerUtil.getNearPlayers((double)ConfigFile.SPECS_POWER_NEAR.getInteger(), target.getPlayer());
        if (players.isEmpty()) {
            MEnum.NEAR_NONE.sendTo(sender, target.getName());
            return;
        }
        MEnum.NEAR_PLAYER.sendTo(sender, target.getName());
        players.forEach(proche -> {
            double distance = target.getPlayer().getLocation().distance(proche.getLocation());
            MEnum.NEAR_SHOW_PLAYER.sendTo(sender, UHCPlayerManager.getPlayer(proche).getName(), Math.round(distance));
        });
    }
}

