/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.commands.host.chat;

import eu.scorpionltd.annotations.commands.Command;
import eu.scorpionltd.annotations.commands.CommandArgs;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.permissions.Permissions;
import eu.scorpionltd.utils.task.Cooldown;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.entity.Player;

public class VoteCommand {
    private int yes = 0;
    private int no = 0;
    private boolean haveSondage = false;
    private List<UUID> hasVoted = new ArrayList<UUID>();

    @Command(name="vote", description="Create a vote", usage="Usage: /vote <Message> or /vote yes|no")
    public void onCommand(CommandArgs args) {
        if (!args.isPlayer() || args.length() == 0) {
            return;
        }
        Player player = args.getPlayer();
        if (args.length() == 1 && this.haveSondage) {
            String arg0 = args.getArgs(0);
            if (arg0.equalsIgnoreCase("yes") && !this.hasVoted.contains(player.getUniqueId())) {
                this.hasVoted.add(player.getUniqueId());
                ++this.yes;
                MEnum.VOTE_YES.sendTo(player, new Object[0]);
            }
            if (arg0.equalsIgnoreCase("no") && !this.hasVoted.contains(player.getUniqueId())) {
                this.hasVoted.add(player.getUniqueId());
                ++this.no;
                MEnum.VOTE_NO.sendTo(player, new Object[0]);
            }
            return;
        }
        if (!Permissions.VOTE_CMD.hasPerm(player)) {
            MEnum.NO_PERMISSION.sendTo(player, new Object[0]);
            return;
        }
        if (this.haveSondage) {
            MEnum.VOTE_IN_PROGRESS.sendTo(player, new Object[0]);
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length(); ++i) {
            sb.append(args.getArgs(i));
            sb.append(" ");
        }
        final String msg = sb.toString();
        this.yes = 0;
        this.no = 0;
        this.hasVoted.clear();
        this.haveSondage = true;
        MEnum.VOTE_START.sendAll(msg);
        new Cooldown(30){

            public void onFinish() {
                VoteCommand.this.haveSondage = false;
                VoteCommand.this.hasVoted.clear();
                MEnum.VOTE_FINISH.sendAll(msg, VoteCommand.this.yes, VoteCommand.this.no);
            }
        };
    }
}

