/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.commands.host.chat;

import eu.scorpionltd.annotations.commands.Command;
import eu.scorpionltd.annotations.commands.CommandArgs;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.permissions.Permissions;
import eu.scorpionltd.uhc.util.chat.ChatUtil;
import eu.scorpionltd.uhc.util.world.MathUtil;
import org.bukkit.entity.Player;

public class SetGroupeCommand {
    @Command(name="setgroup", description="Set group of players", usage="Usage: /setgroup <Number>")
    public void onCommand(CommandArgs args) {
        if (!args.isPlayer()) {
            return;
        }
        Player player = args.getPlayer();
        if (!Permissions.SETGROUP_CMD.hasPerm(player)) {
            MEnum.NO_PERMISSION.sendTo(player, new Object[0]);
            return;
        }
        if (args.getArgs().length != 1) {
            MEnum.SETGROUP_USE.sendTo(player, new Object[0]);
            return;
        }
        String arg1 = args.getArgs(0);
        if (!MathUtil.isInt(arg1)) {
            MEnum.NOT_NUMBER.sendTo(player, new Object[0]);
            return;
        }
        int number = Integer.parseInt(arg1);
        if (number <= 0) {
            MEnum.NUMBER_POSITIVE.sendTo(player, new Object[0]);
            return;
        }
        ChatUtil.changeGroupes(number);
        MEnum.SETGROUP_CHANGE.sendTo(player, number);
        MEnum.SETGROUP_SEND_INFOS_TO_ALL.sendAll(number);
    }
}

