/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc.commands.host;

import eu.scorpionltd.annotations.commands.Command;
import eu.scorpionltd.annotations.commands.CommandArgs;
import eu.scorpionltd.uhc.events.custom.server.HostChangeEvent;
import eu.scorpionltd.uhc.manager.langues.msg.MEnum;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.players.permissions.Permissions;
import eu.scorpionltd.uhc.manager.settings.config.ConfigFile;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class HostCommand {
    @Command(name="sethost", description="Set host of game", usage="Usage: /sethost <Player>")
    public void onCommand(CommandArgs args) {
        if (!(args.getSender() instanceof Player)) {
            return;
        }
        Player p = args.getPlayer();
        if (!Permissions.HOST_CMD.hasPerm(p)) {
            MEnum.NO_PERMISSION.sendTo(p, new Object[0]);
            return;
        }
        if (args.length() != 1) {
            MEnum.SET_HOST_USE.sendTo(p, new Object[0]);
            return;
        }
        Player newHost = Bukkit.getPlayer((String)args.getArgs(0));
        if (newHost == null || !Permissions.HOST_CMD.hasPerm(p)) {
            MEnum.NO_CONNECTED.sendTo(p, new Object[0]);
            return;
        }
        UHCPlayer actualHost = UHCPlayerManager.getActualHost();
        if (actualHost != null) {
            actualHost.setHost(false);
            Player playerHost = actualHost.getPlayer();
            if (playerHost != null) {
                playerHost.setPlayerListName(actualHost.getRankName());
            }
        }
        UHCPlayer up = UHCPlayerManager.getPlayer(newHost.getUniqueId());
        up.setHost(true);
        newHost.setPlayerListName(ConfigFile.TEXT_PLAYER_HOST.getString() + up.getName());
        MEnum.SET_HOST_PLAYER.sendAll(newHost.getName());
        Bukkit.getPluginManager().callEvent((Event)new HostChangeEvent(actualHost, up));
    }
}

