/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.uhc;

import eu.scorpionltd.API;
import eu.scorpionltd.uhc.commands.CommandRegister;
import eu.scorpionltd.uhc.events.EventRegister;
import eu.scorpionltd.uhc.manager.GameManager;
import eu.scorpionltd.uhc.manager.modules.ModuleManager;
import eu.scorpionltd.uhc.manager.players.UHCPlayer;
import eu.scorpionltd.uhc.manager.players.UHCPlayerManager;
import eu.scorpionltd.uhc.manager.teams.UHCTeam;
import eu.scorpionltd.uhc.manager.teams.UHCTeamManager;
import eu.scorpionltd.uhc.scoreboard.UHCScoreboard;
import eu.scorpionltd.uhc.util.world.monde.LobbyUtil;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import java.util.List;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class UHC
extends JavaPlugin {
    private static UHC instance;
    private static UHCScoreboard scoreboard;

    public void onLoad() {
        LobbyUtil.resetLobby((Plugin)this);
    }

    public void onEnable() {
        instance = this;
        API.getLicenceManager().loadPlugin((Plugin)this);
        CommandRegister.setupCommands(this);
        EventRegister.registerStartEvents(this);
        GameManager.setupHost();
        scoreboard = new UHCScoreboard();
        scoreboard.uptadeAllTime();
        scoreboard.setupClassement();
        API.getInstance().sendConsole("Demarrage du plugin SupUHC.");
    }

    public void onDisable() {
        GameManager.resetGame();
        API.getInstance().sendConsole("Arret du plugin SupUHC.");
    }

    public static UHC getInstance() {
        return instance;
    }

    public static UHCScoreboard getScoreboard() {
        return scoreboard;
    }

    public static UHCTeamManager getTeamManager() {
        return UHCTeamManager.getInstance();
    }

    public static List<UHCTeam> getTeams() {
        return UHC.getTeamManager().getTeams();
    }

    public static List<UHCTeam> getConnectedTeams() {
        return UHC.getTeamManager().getConnectedTeams();
    }

    public static List<UHCTeam> getAliveTeams() {
        return UHC.getTeamManager().getAliveTeams();
    }

    public static UHCTeam getTeam(UHCPlayer up) {
        return UHC.getTeamManager().getTeam(up);
    }

    public static UHCTeam getTeam(ScorpionPlayer sp) {
        return UHC.getTeam(UHCPlayerManager.getPlayer(sp));
    }

    public static UHCTeam getTeam(Player p) {
        return UHC.getTeam(UHCPlayerManager.getPlayer(p));
    }

    public static UHCTeam getTeam(UUID uuid) {
        return UHC.getTeam(UHCPlayerManager.getPlayer(uuid));
    }

    public static boolean isSameTeam(Player player, Player target) {
        UHCTeam playerTeam = UHC.getTeam(player);
        UHCTeam targetTeam = UHC.getTeam(target);
        return playerTeam != null && targetTeam != null && playerTeam == targetTeam;
    }

    public boolean isPRO() {
        return ModuleManager.containsModule("Module-UHCPro");
    }

    public static void main(String[] args) {
    }
}

