/*
 * Decompiled with CFR 0.152.
 */
package javax.json.bind.spi;

import java.util.Iterator;
import java.util.ServiceLoader;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbException;

public abstract class JsonbProvider {
    private static final String DEFAULT_PROVIDER = "org.apache.johnzon.jsonb.JohnzonProvider";

    public static JsonbProvider provider() {
        Iterator<JsonbProvider> it = ServiceLoader.load(JsonbProvider.class).iterator();
        if (it.hasNext()) {
            return it.next();
        }
        try {
            return (JsonbProvider)JsonbProvider.class.cast(Thread.currentThread().getContextClassLoader().loadClass(DEFAULT_PROVIDER).newInstance());
        }
        catch (ClassNotFoundException cnfe) {
            throw new JsonbException("org.apache.johnzon.jsonb.JohnzonProvider not found", cnfe);
        }
        catch (Exception x) {
            throw new JsonbException("org.apache.johnzon.jsonb.JohnzonProvider couldn't be instantiated: " + x, x);
        }
    }

    public static JsonbProvider provider(String providerFqn) {
        if (providerFqn == null) {
            throw new IllegalArgumentException();
        }
        for (JsonbProvider provider : ServiceLoader.load(JsonbProvider.class)) {
            if (!providerFqn.equals(provider.getClass().getName())) continue;
            return provider;
        }
        String msg = providerFqn + " not found";
        throw new JsonbException(msg, new ClassNotFoundException(msg));
    }

    public abstract JsonbBuilder create();
}

