/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.utils.variable.list;

import eu.scorpionltd.utils.variable.Variable;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class VariableLong
extends Variable {
    private long value;
    private long max;
    private long min;
    private long green;
    private long yellow;
    private long red;

    public VariableLong(String key, ItemStack item, long defaultvalue, long min, long max, long green, long yellow, long red) {
        super(key, item);
        this.value = defaultvalue;
        this.min = min;
        this.max = max;
        this.green = green;
        this.yellow = yellow;
        this.red = red;
    }

    public VariableLong(String key, ItemStack item, long defaultvalue, long min, long max) {
        this(key, item, defaultvalue, min, max, 1L, 2L, 3L);
    }

    public VariableLong(String key, ItemStack item, long defaultvalue) {
        this(key, item, defaultvalue, Long.MIN_VALUE, Long.MAX_VALUE, 1L, 2L, 3L);
    }

    public VariableLong(String key, ItemStack item) {
        this(key, item, 0L, Long.MIN_VALUE, Long.MAX_VALUE, 1L, 2L, 3L);
    }

    public VariableLong(String key) {
        this(key, new ItemStack(Material.BARRIER), 0L, Long.MIN_VALUE, Long.MAX_VALUE, 1L, 2L, 3L);
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }

    public boolean incrementValue(long value) {
        if (this.value + value < this.min) {
            this.value = this.min;
            return false;
        }
        if (this.value + value > this.max) {
            this.value = this.max;
            return false;
        }
        this.value += value;
        return true;
    }

    public boolean addValue(long value) {
        if (this.value + value > this.max) {
            this.value = this.max;
            return false;
        }
        this.value += value;
        return true;
    }

    public boolean removeValue(long value) {
        if (this.value - value < this.min) {
            this.value = this.min;
            return false;
        }
        this.value -= value;
        return true;
    }

    public long getGreen() {
        return this.green;
    }

    public boolean addGreen() {
        return this.addValue(this.green);
    }

    public boolean removeGreen() {
        return this.removeValue(this.green);
    }

    public long getYellow() {
        return this.yellow;
    }

    public boolean addYellow() {
        return this.addValue(this.yellow);
    }

    public boolean removeYellow() {
        return this.removeValue(this.yellow);
    }

    public long getRed() {
        return this.red;
    }

    public boolean addRed() {
        return this.addValue(this.red);
    }

    public boolean removeRed() {
        return this.removeValue(this.red);
    }
}

