/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.utils.variable.list;

import eu.scorpionltd.utils.variable.Variable;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class VariableInteger
extends Variable {
    private int value;
    private int max;
    private int min;
    private int green;
    private int yellow;
    private int red;

    public VariableInteger(String key, ItemStack item, int defaultvalue, int min, int max, int green, int yellow, int red) {
        super(key, item);
        this.value = defaultvalue;
        this.min = min;
        this.max = max;
        this.green = green;
        this.yellow = yellow;
        this.red = red;
    }

    public VariableInteger(String key, ItemStack item, int defaultvalue, int green, int yellow, int red) {
        this(key, item, defaultvalue, Integer.MIN_VALUE, Integer.MAX_VALUE, green, yellow, red);
    }

    public VariableInteger(String key, ItemStack item, int defaultvalue, int min, int max) {
        this(key, item, defaultvalue, min, max, 1, 2, 3);
    }

    public VariableInteger(String key, ItemStack item, int defaultvalue) {
        this(key, item, defaultvalue, Integer.MIN_VALUE, Integer.MAX_VALUE, 1, 2, 3);
    }

    public VariableInteger(String key, ItemStack item) {
        this(key, item, 0, Integer.MIN_VALUE, Integer.MAX_VALUE, 1, 2, 3);
    }

    public VariableInteger(String key) {
        this(key, new ItemStack(Material.BARRIER), 0, Integer.MIN_VALUE, Integer.MAX_VALUE, 1, 2, 3);
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public boolean incrementValue(int value) {
        if (this.value + value < this.min) {
            this.value = this.min;
            return false;
        }
        if (this.value + value > this.max) {
            this.value = this.max;
            return false;
        }
        this.value += value;
        return true;
    }

    public boolean addValue(int value) {
        if (this.value + value > this.max) {
            this.value = this.max;
            return false;
        }
        this.value += value;
        return true;
    }

    public boolean removeValue(int value) {
        if (this.value - value < this.min) {
            this.value = this.min;
            return false;
        }
        this.value -= value;
        return true;
    }

    public int getGreen() {
        return this.green;
    }

    public boolean addGreen() {
        return this.addValue(this.green);
    }

    public boolean removeGreen() {
        return this.removeValue(this.green);
    }

    public int getYellow() {
        return this.yellow;
    }

    public boolean addYellow() {
        return this.addValue(this.yellow);
    }

    public boolean removeYellow() {
        return this.removeValue(this.yellow);
    }

    public int getRed() {
        return this.red;
    }

    public boolean addRed() {
        return this.addValue(this.red);
    }

    public boolean removeRed() {
        return this.removeValue(this.red);
    }
}

