/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.utils.variable.list;

import eu.scorpionltd.utils.variable.Variable;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class VariableDouble
extends Variable {
    private double value;
    private double max;
    private double min;
    private double green;
    private double yellow;
    private double red;

    public VariableDouble(String key, ItemStack item, double defaultvalue, double min, double max, double green, double yellow, double red) {
        super(key, item);
        this.value = defaultvalue;
        this.min = min;
        this.max = max;
        this.green = green;
        this.yellow = yellow;
        this.red = red;
    }

    public VariableDouble(String key, ItemStack item, double defaultvalue, double min, double max) {
        this(key, item, defaultvalue, min, max, 1.0, 2.0, 3.0);
    }

    public VariableDouble(String key, ItemStack item, double defaultvalue) {
        this(key, item, defaultvalue, Double.MIN_VALUE, Double.MAX_VALUE, 1.0, 2.0, 3.0);
    }

    public VariableDouble(String key, ItemStack item) {
        this(key, item, 0.0, Double.MIN_VALUE, Double.MAX_VALUE, 1.0, 2.0, 3.0);
    }

    public VariableDouble(String key) {
        this(key, new ItemStack(Material.BARRIER), 0.0, Double.MIN_VALUE, Double.MAX_VALUE, 1.0, 2.0, 3.0);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public boolean incrementValue(double value) {
        if (this.value + value < this.min) {
            this.value = this.min;
            return false;
        }
        if (this.value + value > this.max) {
            this.value = this.max;
            return false;
        }
        this.value += value;
        return true;
    }

    public boolean addValue(double value) {
        if (this.value + value > this.max) {
            this.value = this.max;
            return false;
        }
        this.value += value;
        return true;
    }

    public boolean removeValue(double value) {
        if (this.value - value < this.min) {
            this.value = this.min;
            return false;
        }
        this.value -= value;
        return true;
    }

    public double getGreen() {
        return this.green;
    }

    public boolean addGreen() {
        return this.addValue(this.green);
    }

    public boolean removeGreen() {
        return this.removeValue(this.green);
    }

    public double getYellow() {
        return this.yellow;
    }

    public boolean addYellow() {
        return this.addValue(this.yellow);
    }

    public boolean removeYellow() {
        return this.removeValue(this.yellow);
    }

    public double getRed() {
        return this.red;
    }

    public boolean addRed() {
        return this.addValue(this.red);
    }

    public boolean removeRed() {
        return this.removeValue(this.red);
    }
}

