/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.utils.task;

import eu.scorpionltd.API;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public abstract class Countdown {
    private int time;
    private String key;
    private String prefix;
    private UUID uuid;
    protected BukkitTask task;

    public Countdown(String key, String prefix, int time, Player p) {
        this(key, prefix, time, p.getUniqueId());
    }

    public Countdown(String key, String prefix, int time, UUID uuid) {
        this.key = key;
        this.prefix = prefix;
        this.time = time;
        this.uuid = uuid;
        API.getInstance().getCountdowns().add(this);
    }

    public final void start() {
        this.task = new BukkitRunnable(){

            public void run() {
                if (Countdown.this.time != 0) {
                    Countdown.this.onSec(Countdown.this.time);
                } else {
                    Countdown.this.onFinish();
                    Countdown.this.finishCountdown();
                }
                Countdown.this.time--;
            }
        }.runTaskTimer((Plugin)API.getInstance(), 0L, 20L);
    }

    public String getKey() {
        return this.key;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int getTime() {
        return this.time;
    }

    public boolean isActive() {
        return this.time > 0;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void finishCountdown() {
        API.getInstance().getCountdowns().remove(API.getInstance().getCountdownByKey(this.key, this.uuid));
        this.task.cancel();
    }

    public abstract void onSec(int var1);

    public abstract void onFinish();
}

