/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.utils.player.utils;

import eu.scorpionltd.API;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.server.v1_8_R3.ChunkCoordIntPair;
import net.minecraft.server.v1_8_R3.EntityPlayer;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerUtils {
    private ScorpionPlayer scorpionPlayer;

    public PlayerUtils(ScorpionPlayer scorpionPlayer) {
        this.scorpionPlayer = scorpionPlayer;
    }

    public ItemStack getSkullInfosItem() {
        ItemStack skull = new ItemStack(Material.SKULL_ITEM, 1, 3);
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        meta.setOwner(this.scorpionPlayer.getPlayer().getName());
        meta.setDisplayName(ChatColor.GOLD + "Informations");
        String prefixLore = ChatColor.YELLOW + " ";
        meta.setLore(Arrays.asList("", prefixLore + "Pseudo: " + ChatColor.AQUA + "" + ChatColor.BOLD + this.scorpionPlayer.getPlayer().getName()));
        skull.setItemMeta((ItemMeta)meta);
        return skull;
    }

    public float getAbsorptionHearths() {
        return ((CraftPlayer)this.scorpionPlayer.getPlayer()).getHandle().getAbsorptionHearts();
    }

    public void setAbsorptionHearths(float hearths) {
        ((CraftPlayer)this.scorpionPlayer.getPlayer()).getHandle().setAbsorptionHearts(hearths);
    }

    public boolean hasJumpPotion() {
        return this.scorpionPlayer.getPlayer().hasPotionEffect(PotionEffectType.JUMP);
    }

    public boolean isInWater() {
        return this.scorpionPlayer.getPlayer().getLocation().getBlock().isLiquid() || this.scorpionPlayer.getPlayer().getLocation().getBlock().getRelative(BlockFace.DOWN).isLiquid() || this.scorpionPlayer.getPlayer().getLocation().getBlock().getRelative(BlockFace.UP).isLiquid();
    }

    public boolean isInWeb() {
        return this.scorpionPlayer.getPlayer().getLocation().getBlock().getType() == Material.WEB || this.scorpionPlayer.getPlayer().getLocation().getBlock().getRelative(BlockFace.DOWN).getType() == Material.WEB || this.scorpionPlayer.getPlayer().getLocation().getBlock().getRelative(BlockFace.UP).getType() == Material.WEB;
    }

    public void resendChunk(Location loc) {
        EntityPlayer ep = ((CraftPlayer)this.scorpionPlayer.getPlayer()).getHandle();
        ep.chunkCoordIntPairQueue.add(new ChunkCoordIntPair(loc.getChunk().getX(), loc.getChunk().getZ()));
    }

    public void resendBlock(Location loc) {
        this.scorpionPlayer.getPlayer().sendBlockChange(loc, loc.getBlock().getType(), loc.getBlock().getData());
    }

    public void removeAllPotionsEffect() {
        for (PotionEffect pe : this.scorpionPlayer.getPlayer().getActivePotionEffects()) {
            this.scorpionPlayer.getPlayer().removePotionEffect(pe.getType());
        }
    }

    public void makeTraveling(Location p1, Location p2, int duration) {
        try {
            int time = duration * 20;
            ArrayList<Double> diffs = new ArrayList<Double>();
            ArrayList travelTimes = new ArrayList();
            double totalDiff = 0.0;
            double diff = this.positionDifference(p1, p2);
            diffs.add(diff);
            double finalTotalDiff = totalDiff += diff;
            diffs.forEach(aDouble -> travelTimes.add((int)(aDouble / finalTotalDiff * (double)time)));
            final ArrayList<Location> tps = new ArrayList<Location>();
            World w = this.scorpionPlayer.getPlayer().getWorld();
            int t = (Integer)travelTimes.get(0);
            double moveX = p2.getX() - p1.getX();
            double moveY = p2.getY() - p1.getY();
            double moveZ = p2.getZ() - p1.getZ();
            double movePitch = p2.getPitch() - p1.getPitch();
            double yawDiff = Math.abs(p2.getYaw() - p1.getYaw());
            double c = 0.0;
            c = yawDiff <= 180.0 ? (p1.getYaw() < p2.getYaw() ? yawDiff : -yawDiff) : (p1.getYaw() < p2.getYaw() ? -(360.0 - yawDiff) : 360.0 - yawDiff);
            double d = c / (double)t;
            for (int x = 0; x < t; ++x) {
                Location l = new Location(w, p1.getX() + moveX / (double)t * (double)x, p1.getY() + moveY / (double)t * (double)x, p1.getZ() + moveZ / (double)t * (double)x, (float)((double)p1.getYaw() + d * (double)x), (float)((double)p1.getPitch() + movePitch / (double)t * (double)x));
                tps.add(l);
            }
            this.scorpionPlayer.getPlayer().setAllowFlight(true);
            this.scorpionPlayer.getPlayer().teleport((Location)tps.get(0));
            this.scorpionPlayer.getPlayer().setFlying(true);
            new BukkitRunnable(){
                private int counter = 0;

                public void run() {
                    if (this.counter < tps.size()) {
                        PlayerUtils.this.scorpionPlayer.getPlayer().teleport((Location)tps.get(this.counter));
                        ++this.counter;
                    } else {
                        PlayerUtils.this.scorpionPlayer.getPlayer().setAllowFlight(false);
                        PlayerUtils.this.scorpionPlayer.getPlayer().setFlying(false);
                        this.cancel();
                        return;
                    }
                }
            }.runTaskTimer((Plugin)API.getInstance(), 0L, 1L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private double positionDifference(Location cLoc, Location eLoc) {
        double dZ;
        double cX = cLoc.getX();
        double cY = cLoc.getY();
        double cZ = cLoc.getZ();
        double eX = eLoc.getX();
        double eY = eLoc.getY();
        double eZ = eLoc.getZ();
        double dX = eX - cX;
        if (dX < 0.0) {
            dX = -dX;
        }
        if ((dZ = eZ - cZ) < 0.0) {
            dZ = -dZ;
        }
        double dXZ = Math.hypot(dX, dZ);
        double dY = eY - cY;
        if (dY < 0.0) {
            dY = -dY;
        }
        double dXYZ = Math.hypot(dXZ, dY);
        return dXYZ;
    }
}

