/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.utils.objets.stand;

import eu.scorpionltd.API;
import eu.scorpionltd.utils.objets.SymbolBank;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.v1_8_R3.EntityArmorStand;
import net.minecraft.server.v1_8_R3.EntityLiving;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityVelocity;
import net.minecraft.server.v1_8_R3.PacketPlayOutSpawnEntityLiving;
import net.minecraft.server.v1_8_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_8_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class ArmorStandHealth {
    private Player player;
    private BukkitTask task;
    private int delay = 0;
    private int period = 1;
    private List<UUID> playersee;
    private EntityArmorStand stand;

    public ArmorStandHealth(Player player) {
        this.player = player;
        this.playersee = new ArrayList<UUID>();
        this.updateArmorStand(player);
    }

    public void sendArmorStand() {
        this.task = Bukkit.getScheduler().runTaskTimer((Plugin)API.getInstance(), new BukkitRunnable(){

            public void run() {
                if (ArmorStandHealth.this.player != null && !ArmorStandHealth.this.player.isDead()) {
                    for (UUID uuid : ArmorStandHealth.this.playersee) {
                        Player pl = Bukkit.getPlayer((UUID)uuid);
                        if (pl == null || !pl.isOnline() || pl.getGameMode().equals((Object)GameMode.SPECTATOR)) continue;
                        PacketPlayOutEntityDestroy packet3 = new PacketPlayOutEntityDestroy(new int[]{ArmorStandHealth.this.stand.getId()});
                        ((CraftPlayer)pl).getHandle().playerConnection.sendPacket((Packet)packet3);
                        ArmorStandHealth.this.updateArmorStand(ArmorStandHealth.this.player);
                        PacketPlayOutSpawnEntityLiving packet = new PacketPlayOutSpawnEntityLiving((EntityLiving)ArmorStandHealth.this.stand);
                        Vector vel = ArmorStandHealth.this.player.getVelocity();
                        PacketPlayOutEntityVelocity packet2 = new PacketPlayOutEntityVelocity(ArmorStandHealth.this.stand.getId(), vel.getX(), vel.getY() + 1.5, vel.getZ());
                        ((CraftPlayer)pl).getHandle().playerConnection.sendPacket((Packet)packet);
                        ((CraftPlayer)pl).getHandle().playerConnection.sendPacket((Packet)packet2);
                    }
                }
            }
        }, (long)this.delay, (long)this.period);
    }

    public void cancel() {
        if (this.task != null) {
            for (UUID uuid : this.playersee) {
                Player pl = Bukkit.getPlayer((UUID)uuid);
                PacketPlayOutEntityDestroy packet3 = new PacketPlayOutEntityDestroy(new int[]{this.stand.getId()});
                ((CraftPlayer)pl).getHandle().playerConnection.sendPacket((Packet)packet3);
            }
            this.task.cancel();
        }
    }

    public void addSeePlayer(Player player) {
        this.playersee.add(player.getUniqueId());
    }

    public void removeSeePlayer(Player player) {
        this.playersee.remove(player.getUniqueId());
    }

    public void setDelay(int delay, int period) {
        this.delay = delay;
        this.period = period;
    }

    public int getDelay() {
        return this.delay;
    }

    public int getPeriod() {
        return this.period;
    }

    public Entity getEntity() {
        return this.player;
    }

    private EntityArmorStand updateArmorStand(Player player) {
        Location loc = player.getLocation();
        this.stand = new EntityArmorStand((World)((CraftWorld)loc.getWorld()).getHandle(), loc.getX(), loc.getY() + 1.0, loc.getZ());
        this.updateCustomName(player);
        this.stand.setCustomNameVisible(true);
        this.stand.setInvisible(true);
        this.stand.setGravity(false);
        this.stand.setSmall(true);
        return this.stand;
    }

    private void updateCustomName(Player player) {
        this.stand.setCustomName("" + ChatColor.AQUA + (int)Math.round(player.getHealth() / 2.0) + " " + SymbolBank.HEARTH);
    }
}

