/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.utils.objets.stand;

import eu.scorpionltd.API;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.v1_8_R3.EntityArmorStand;
import net.minecraft.server.v1_8_R3.EntityLiving;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityVelocity;
import net.minecraft.server.v1_8_R3.PacketPlayOutSpawnEntityLiving;
import net.minecraft.server.v1_8_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_8_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class ArmorStandEntity {
    private Entity entity;
    private String name;
    private BukkitTask task;
    private int delay = 0;
    private int period = 3;
    private List<UUID> playersee;
    private EntityArmorStand stand;

    public ArmorStandEntity(Entity entity, String name) {
        this.entity = entity;
        this.name = name;
        this.playersee = new ArrayList<UUID>();
        this.updateArmorStand(entity, name);
    }

    public void sendArmorStand() {
        this.task = Bukkit.getScheduler().runTaskTimer((Plugin)API.getInstance(), new BukkitRunnable(){

            public void run() {
                if (ArmorStandEntity.this.entity != null && !ArmorStandEntity.this.entity.isDead()) {
                    for (UUID uuid : ArmorStandEntity.this.playersee) {
                        Player pl = Bukkit.getPlayer((UUID)uuid);
                        if (pl == null || !pl.isOnline() || pl.getGameMode().equals((Object)GameMode.SPECTATOR)) continue;
                        PacketPlayOutEntityDestroy packet3 = new PacketPlayOutEntityDestroy(new int[]{ArmorStandEntity.this.stand.getId()});
                        ((CraftPlayer)pl).getHandle().playerConnection.sendPacket((Packet)packet3);
                        ArmorStandEntity.this.updateArmorStand(ArmorStandEntity.this.entity, ArmorStandEntity.this.name);
                        PacketPlayOutSpawnEntityLiving packet = new PacketPlayOutSpawnEntityLiving((EntityLiving)ArmorStandEntity.this.stand);
                        Vector vel = ArmorStandEntity.this.entity.getVelocity();
                        PacketPlayOutEntityVelocity packet2 = new PacketPlayOutEntityVelocity(ArmorStandEntity.this.stand.getId(), vel.getX(), vel.getY(), vel.getZ());
                        ((CraftPlayer)pl).getHandle().playerConnection.sendPacket((Packet)packet);
                        ((CraftPlayer)pl).getHandle().playerConnection.sendPacket((Packet)packet2);
                    }
                }
            }
        }, (long)this.delay, (long)this.period);
    }

    public void cancel() {
        if (this.task != null) {
            for (UUID uuid : this.playersee) {
                Player pl = Bukkit.getPlayer((UUID)uuid);
                PacketPlayOutEntityDestroy packet3 = new PacketPlayOutEntityDestroy(new int[]{this.stand.getId()});
                ((CraftPlayer)pl).getHandle().playerConnection.sendPacket((Packet)packet3);
            }
            this.task.cancel();
        }
    }

    public void addSeePlayer(Player player) {
        this.playersee.add(player.getUniqueId());
    }

    public void removeSeePlayer(Player player) {
        this.playersee.remove(player.getUniqueId());
    }

    public void setDelay(int delay, int period) {
        this.delay = delay;
        this.period = period;
    }

    public int getDelay() {
        return this.delay;
    }

    public int getPeriod() {
        return this.period;
    }

    public Entity getEntity() {
        return this.entity;
    }

    private EntityArmorStand updateArmorStand(Entity entity, String name) {
        Location loc = entity.getLocation();
        this.stand = new EntityArmorStand((World)((CraftWorld)loc.getWorld()).getHandle(), loc.getX(), loc.getY(), loc.getZ());
        this.stand.setCustomName(name);
        this.stand.setCustomNameVisible(true);
        this.stand.setInvisible(true);
        this.stand.setGravity(false);
        this.stand.setSmall(true);
        return this.stand;
    }
}

