/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.utils.objets.hologram;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class HologramCreator {
    private static List<HologramCreator> holos = new ArrayList<HologramCreator>();
    private List<ArmorStand> stands = new ArrayList<ArmorStand>();
    private boolean spawned;
    private Location location;

    public static List<HologramCreator> getHolos() {
        return holos;
    }

    public static void removeAll() {
        for (HologramCreator holo : holos) {
            holo.remove();
            for (Entity entity : holo.getLocation().getWorld().getNearbyEntities(holo.getLocation(), 1.0, 1.0, 1.0)) {
                if (entity == null || !(entity instanceof ArmorStand)) continue;
                entity.remove();
            }
        }
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    private Location getLocation() {
        return this.location.clone();
    }

    public HologramCreator(Location location, List<String> messages) {
        this.location = location;
        Location loc = this.getLocation();
        World world = location.getWorld();
        for (String message : messages) {
            ArmorStand armor = (ArmorStand)world.spawnEntity(loc, EntityType.ARMOR_STAND);
            armor.setVisible(false);
            armor.setCustomNameVisible(true);
            armor.setCustomName(message);
            armor.setGravity(false);
            armor.setCanPickupItems(false);
            loc.setY(loc.getY() - 0.3);
            this.stands.add(armor);
        }
        holos.add(this);
        this.setSpawned(true);
    }

    public void setSpawned(boolean spawned) {
        this.spawned = spawned;
    }

    public void setMessages(List<String> messages) {
        for (ArmorStand armor : this.stands) {
            armor.remove();
        }
        this.stands.clear();
        Location loc = this.getLocation();
        World world = loc.getWorld();
        for (String message : messages) {
            ArmorStand armor = (ArmorStand)world.spawnEntity(loc, EntityType.ARMOR_STAND);
            armor.setVisible(false);
            armor.setCustomNameVisible(true);
            armor.setCustomName(message);
            armor.setGravity(false);
            loc.setY(loc.getY() - 0.3);
            this.stands.add(armor);
        }
    }

    public void remove() {
        if (!this.spawned) {
            return;
        }
        this.setSpawned(false);
        for (ArmorStand armor : this.stands) {
            armor.remove();
            for (Entity entity : armor.getLocation().getWorld().getNearbyEntities(armor.getLocation(), 0.0, 1.0, 0.0)) {
                if (entity == null || !(entity instanceof ArmorStand)) continue;
                entity.remove();
            }
        }
        holos.remove(this);
    }
}

