/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.utils.npc;

import eu.scorpionltd.listeners.custom.ScorpionNPCInteract;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.server.v1_8_R3.Packet;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.event.Event;

public class PacketReader {
    private ScorpionPlayer player;
    Channel channel;

    public PacketReader(ScorpionPlayer player) {
        this.player = player;
    }

    public void inject() {
        CraftPlayer cPlayer = (CraftPlayer)this.player.getPlayer();
        this.channel = cPlayer.getHandle().playerConnection.networkManager.channel;
        this.channel.pipeline().addAfter("decoder", "PacketInjector", (ChannelHandler)new MessageToMessageDecoder<Packet<?>>(){

            protected void decode(ChannelHandlerContext arg0, Packet<?> packet, List<Object> arg2) throws Exception {
                arg2.add(packet);
                PacketReader.this.readPacket(PacketReader.this.player, packet);
            }
        });
    }

    public void uninject() {
        if (this.channel.pipeline().get("PacketInjector") != null) {
            this.channel.pipeline().remove("PacketInjector");
        }
    }

    public void readPacket(ScorpionPlayer scorpionPlayer, Packet<?> packet) {
        if (packet.getClass().getSimpleName().equalsIgnoreCase("PacketPlayInUseEntity")) {
            int id = (Integer)this.getValue(packet, "a");
            if (this.getValue(packet, "action").toString().equalsIgnoreCase("ATTACK")) {
                Bukkit.getPluginManager().callEvent((Event)new ScorpionNPCInteract(scorpionPlayer, id));
            } else if (this.getValue(packet, "action").toString().equalsIgnoreCase("INTERACT")) {
                Bukkit.getPluginManager().callEvent((Event)new ScorpionNPCInteract(scorpionPlayer, id));
            }
        }
    }

    public void setValue(Object obj, String name, Object value) {
        try {
            Field field = obj.getClass().getDeclaredField(name);
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object getValue(Object obj, String name) {
        try {
            Field field = obj.getClass().getDeclaredField(name);
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

