/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.utils.npc;

import eu.scorpionltd.API;
import eu.scorpionltd.utils.npc.NPCInterface;
import eu.scorpionltd.utils.npc.TimeManager;
import java.util.HashMap;
import java.util.TimerTask;
import org.bukkit.entity.Player;

public class NPCManager {
    private API pl;
    private static HashMap<String, NPCInterface> npcsID;
    private TimerTask task;
    private TimeManager timer;

    public NPCManager(API pl) {
        this.pl = pl;
        npcsID = new HashMap();
        this.timer = new TimeManager();
        this.task = new TimerTask(){

            @Override
            public void run() {
                for (NPCInterface npc : npcsID.values()) {
                    npc.updateNPC();
                }
            }
        };
        this.timer.setTimertask(this.task);
        this.timer.startTimer(1, 100);
    }

    public boolean registerNPC(NPCInterface npc) {
        if (npcsID.get(npc.type()) != null) {
            return false;
        }
        npc.create();
        npcsID.put(npc.type(), npc);
        return true;
    }

    private NPCInterface getNPC(Player player, Integer npcID) {
        for (NPCInterface npc : npcsID.values()) {
            if (npc.getNPC(player).getEntityID() != npcID.intValue()) continue;
            return npc;
        }
        return null;
    }

    private boolean existsNPC(Player player, Integer npcID) {
        for (NPCInterface npc : npcsID.values()) {
            if (npc.getNPC(player) == null || npc.getNPC(player).getEntityID() != npcID.intValue()) continue;
            return true;
        }
        return false;
    }

    public boolean unregisterNPC(NPCInterface npc) {
        if (npcsID.get(npc.type()) != null) {
            npc.delete();
            npcsID.remove(npc.type());
            return true;
        }
        return false;
    }

    public void unregAll() {
        for (NPCInterface npc : npcsID.values()) {
            npc.delete();
        }
        npcsID.clear();
    }
}

