/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.utils.npc;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.v1_8_R3.DataWatcher;
import net.minecraft.server.v1_8_R3.EntityPlayer;
import net.minecraft.server.v1_8_R3.IChatBaseComponent;
import net.minecraft.server.v1_8_R3.MathHelper;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntity;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityHeadRotation;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_8_R3.PacketPlayOutNamedEntitySpawn;
import net.minecraft.server.v1_8_R3.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_8_R3.PacketPlayOutScoreboardTeam;
import net.minecraft.server.v1_8_R3.WorldSettings;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_8_R3.util.CraftChatMessage;
import org.bukkit.entity.Player;

public class NPC {
    private int entityID;
    private Location location;
    private GameProfile gameprofile;
    private Player player;

    public NPC(Player player, Location location, String name) {
        this.player = player;
        this.entityID = (int)Math.ceil(Math.random() * 1000.0) + 2000;
        this.gameprofile = new GameProfile(UUID.randomUUID(), name);
        this.location = location.clone();
    }

    public void changeSkin(String value, String signature) {
        this.gameprofile.getProperties().put((Object)"textures", (Object)new Property("textures", value, signature));
    }

    public void hideName() {
        try {
            PacketPlayOutScoreboardTeam packet = new PacketPlayOutScoreboardTeam();
            this.setValue(packet, "h", 0);
            this.setValue(packet, "b", this.gameprofile.getName());
            this.setValue(packet, "a", this.gameprofile.getName());
            this.setValue(packet, "e", "never");
            this.setValue(packet, "i", 1);
            Field f = packet.getClass().getDeclaredField("g");
            f.setAccessible(true);
            ((Collection)f.get(packet)).add(this.gameprofile.getName());
            this.sendPacket((Packet<?>)packet, this.player);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void spawn() {
        PacketPlayOutNamedEntitySpawn packet = new PacketPlayOutNamedEntitySpawn();
        this.setValue(packet, "a", this.entityID);
        this.setValue(packet, "b", this.gameprofile.getId());
        this.setValue(packet, "c", this.getFixLocation(this.location.getX()));
        this.setValue(packet, "d", this.getFixLocation(this.location.getY()));
        this.setValue(packet, "e", this.getFixLocation(this.location.getZ()));
        this.setValue(packet, "h", 0);
        DataWatcher w = new DataWatcher(null);
        w.a(6, (Object)Float.valueOf(20.0f));
        w.a(10, (Object)127);
        this.setValue(packet, "i", w);
        this.addToTablist();
        this.sendPacket((Packet<?>)packet, this.player);
        this.headRotation(this.location.getYaw(), this.location.getPitch());
    }

    public void teleport(Location location) {
        PacketPlayOutEntityTeleport packet = new PacketPlayOutEntityTeleport();
        this.setValue(packet, "a", this.entityID);
        this.setValue(packet, "b", this.getFixLocation(location.getX()));
        this.setValue(packet, "c", this.getFixLocation(location.getY()));
        this.setValue(packet, "d", this.getFixLocation(location.getZ()));
        this.sendPacket((Packet<?>)packet, this.player);
        this.headRotation(location.getYaw(), location.getPitch());
        this.location = location.clone();
    }

    public Location getLocation() {
        return this.location.clone();
    }

    public void headRotation(float yaw, float pitch) {
        PacketPlayOutEntity.PacketPlayOutEntityLook packet = new PacketPlayOutEntity.PacketPlayOutEntityLook(this.entityID, this.getFixRotation(yaw), this.getFixRotation(pitch), true);
        PacketPlayOutEntityHeadRotation packetHead = new PacketPlayOutEntityHeadRotation();
        this.setValue(packetHead, "a", this.entityID);
        this.setValue(packetHead, "b", this.getFixRotation(yaw));
        this.sendPacket((Packet<?>)packet, this.player);
        this.sendPacket((Packet<?>)packetHead, this.player);
    }

    public void destroy() {
        PacketPlayOutEntityDestroy packet = new PacketPlayOutEntityDestroy(new int[]{this.entityID});
        this.rmvFromTablist();
        this.sendPacket((Packet<?>)packet, this.player);
    }

    public void addToTablist() {
        try {
            PacketPlayOutPlayerInfo packet = new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, new EntityPlayer[0]);
            Field f = packet.getClass().getDeclaredField("b");
            f.setAccessible(true);
            List list = (List)f.get(packet);
            Class<?> infoDataClass = Class.forName("net.minecraft.server.v1_8_R3.PacketPlayOutPlayerInfo$PlayerInfoData");
            Constructor<?> constructor = infoDataClass.getDeclaredConstructor(PacketPlayOutPlayerInfo.class, GameProfile.class, Integer.TYPE, WorldSettings.EnumGamemode.class, IChatBaseComponent.class);
            constructor.setAccessible(true);
            Object data = constructor.newInstance(packet, this.gameprofile, 1, WorldSettings.EnumGamemode.NOT_SET, CraftChatMessage.fromString((String)this.gameprofile.getName())[0]);
            list.add(data);
            this.sendPacket((Packet<?>)packet, this.player);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void rmvFromTablist() {
        try {
            PacketPlayOutPlayerInfo packet = new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER, new EntityPlayer[0]);
            Field f = packet.getClass().getDeclaredField("b");
            f.setAccessible(true);
            List list = (List)f.get(packet);
            Class<?> infoDataClass = Class.forName("net.minecraft.server.v1_8_R3.PacketPlayOutPlayerInfo$PlayerInfoData");
            Constructor<?> constructor = infoDataClass.getDeclaredConstructor(PacketPlayOutPlayerInfo.class, GameProfile.class, Integer.TYPE, WorldSettings.EnumGamemode.class, IChatBaseComponent.class);
            constructor.setAccessible(true);
            Object data = constructor.newInstance(packet, this.gameprofile, 1, WorldSettings.EnumGamemode.NOT_SET, CraftChatMessage.fromString((String)this.gameprofile.getName())[0]);
            list.add(data);
            this.sendPacket((Packet<?>)packet, this.player);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getFixLocation(double pos) {
        return MathHelper.floor((double)(pos * 32.0));
    }

    public int getEntityID() {
        return this.entityID;
    }

    public byte getFixRotation(float yawpitch) {
        return (byte)(yawpitch * 256.0f / 360.0f);
    }

    public void setValue(Object obj, String name, Object value) {
        try {
            Field field = obj.getClass().getDeclaredField(name);
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Object getValue(Object obj, String name) {
        try {
            Field field = obj.getClass().getDeclaredField(name);
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void sendPacket(Packet<?> packet, Player player) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket(packet);
    }

    public boolean getPlayerIsInArea(Player player, Location loc, Double radius) {
        if (player.getWorld().getName().equals(loc.getWorld().getName())) {
            ArrayList<Double> x = new ArrayList<Double>();
            x.add(loc.getX() + radius);
            x.add(loc.getX() - radius);
            ArrayList<Double> y = new ArrayList<Double>();
            y.add(loc.getY() + radius);
            y.add(loc.getY() - radius);
            ArrayList<Double> z = new ArrayList<Double>();
            z.add(loc.getZ() + radius);
            z.add(loc.getZ() - radius);
            Collections.sort(x);
            Collections.sort(y);
            Collections.sort(z);
            Location l = player.getLocation();
            return l.getX() >= (Double)x.get(0) && l.getX() <= (Double)x.get(1) && l.getY() >= (Double)y.get(0) && l.getY() <= (Double)y.get(1) && l.getZ() >= (Double)z.get(0) && l.getZ() <= (Double)z.get(1);
        }
        return false;
    }
}

