/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.utils.item.armor;

import eu.scorpionltd.utils.item.armor.ArmorListener;
import org.bukkit.inventory.ItemStack;

public enum ArmorType {
    HELMET(5),
    CHESTPLATE(6),
    LEGGINGS(7),
    BOOTS(8);

    private final int slot;

    private ArmorType(int slot) {
        this.slot = slot;
    }

    public static ArmorType matchType(ItemStack itemStack) {
        if (ArmorListener.isAirOrNull(itemStack)) {
            return null;
        }
        String type = itemStack.getType().name();
        if (type.endsWith("_HELMET") || type.endsWith("_SKULL") || type.endsWith("PLAYER_HEAD")) {
            return HELMET;
        }
        if (type.endsWith("_CHESTPLATE") || type.endsWith("ELYTRA")) {
            return CHESTPLATE;
        }
        if (type.endsWith("_LEGGINGS")) {
            return LEGGINGS;
        }
        if (type.endsWith("_BOOTS")) {
            return BOOTS;
        }
        return null;
    }

    public int getSlot() {
        return this.slot;
    }
}

