/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.utils.item;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import eu.scorpionltd.utils.depends.ReflectionHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.server.v1_8_R3.PacketDataSerializer;
import net.minecraft.server.v1_8_R3.PacketPlayOutCustomPayload;
import org.bukkit.Material;
import org.bukkit.SkullType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemUtils {
    public static void openWrittenBook(ItemStack book, Player player) {
        if (book.getType() != Material.WRITTEN_BOOK) {
            return;
        }
        ItemStack previous = player.getInventory().getItemInHand();
        player.getInventory().setItemInHand(book);
        ByteBuf buffer = Unpooled.buffer((int)256);
        buffer.setByte(0, 1);
        buffer.writerIndex(1);
        ReflectionHandler.sendPacket(player, new PacketPlayOutCustomPayload("MC|BOpen", new PacketDataSerializer(buffer)));
        player.getInventory().setItemInHand(previous);
    }

    public static String stackToStr(ItemStack stack) {
        return stack.getType().name() + ", " + stack.getAmount() + ", " + stack.getDurability();
    }

    public static ItemStack strToStack(String string) {
        String[] data = string.split(", ");
        return new ItemStack(Material.matchMaterial((String)data[0]), Integer.parseInt(data[1]), Short.parseShort(data[2]));
    }

    public static ItemStack hideAllAttributes(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        for (ItemFlag itemFlag : ItemFlag.values()) {
            if (!itemFlag.name().startsWith("HIDE_")) continue;
            meta.addItemFlags(new ItemFlag[]{itemFlag});
        }
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack getPlayerHead(String player) {
        ItemStack head = new ItemStack(Material.SKULL_ITEM, 1, (short)SkullType.PLAYER.ordinal());
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        meta.setOwner(player);
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    public static ItemStack getCustomHead(String texture) {
        ItemStack head = new ItemStack(Material.SKULL_ITEM, 1, 3);
        ItemMeta headMeta = head.getItemMeta();
        try {
            ReflectionHandler.setValue(headMeta, "profile", ItemUtils.getHeadCustomizedGameProfile(texture));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        head.setItemMeta(headMeta);
        return head;
    }

    public static GameProfile getHeadCustomizedGameProfile(String texture) {
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        PropertyMap propertyMap = profile.getProperties();
        if (propertyMap == null) {
            throw new IllegalStateException("Profile doesn't contain a property map");
        }
        byte[] encodedData = texture.getBytes();
        propertyMap.put((Object)"textures", (Object)new Property("textures", new String(encodedData)));
        return profile;
    }
}

