/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.utils.item;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class Item {
    Material material;
    String name;
    List<String> lore;
    int amount;
    short durabilite;
    ItemStack item;

    public Item(Material material, String name) {
        this.material = material;
        this.name = name;
        this.amount = 1;
        this.durabilite = 0;
        this.item = new ItemStack(material);
    }

    public Item(Material material, String name, String ... lore) {
        this.material = material;
        this.name = name;
        this.amount = 1;
        this.durabilite = 0;
        ArrayList<String> desc = new ArrayList<String>();
        for (String s : lore) {
            desc.add(s);
            this.lore = desc;
        }
        this.item = new ItemStack(material);
    }

    public Item(Material material, int amount, String name) {
        this.material = material;
        this.name = name;
        this.amount = amount;
        this.durabilite = 0;
        this.item = new ItemStack(material);
    }

    public Item(Material material, int amount, short durabilite, String name) {
        this.material = material;
        this.name = name;
        this.amount = amount;
        this.durabilite = durabilite;
        this.item = new ItemStack(material);
    }

    public Item(Material material, short durabilite, String name) {
        this.material = material;
        this.name = name;
        this.amount = 1;
        this.durabilite = durabilite;
        this.item = new ItemStack(material);
    }

    public Item(ItemStack item) {
        this.material = item.getType();
        this.amount = item.getAmount();
        this.durabilite = item.getDurability();
        if (item.hasItemMeta() && item.getItemMeta().hasDisplayName()) {
            this.name = item.getItemMeta().getDisplayName();
        }
        if (item.hasItemMeta() && item.getItemMeta().hasLore()) {
            this.lore = item.getItemMeta().getLore();
        }
        this.item = item;
    }

    public ItemStack toItemStack() {
        ItemStack item = this.item;
        ItemMeta itemMeta = item.getItemMeta();
        if (this.name != null) {
            itemMeta.setDisplayName(this.name);
        }
        if (this.lore != null) {
            itemMeta.setLore(this.lore);
        }
        item.setItemMeta(itemMeta);
        item.setAmount(this.amount);
        item.setDurability(this.durabilite);
        return item;
    }

    public ItemStack toItemStackWithEnchantAspect() {
        ItemStack item = this.item;
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(this.name);
        itemMeta.setLore(this.lore);
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        itemMeta.addEnchant(Enchantment.DURABILITY, 1, true);
        item.setItemMeta(itemMeta);
        item.setAmount(this.amount);
        item.setDurability(this.durabilite);
        return item;
    }

    public ItemStack toItemStackWithUnbreakable() {
        ItemStack item = this.item;
        item.setAmount(this.amount);
        item.setDurability(this.durabilite);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.spigot().setUnbreakable(true);
        itemMeta.setDisplayName(this.name);
        itemMeta.setLore(this.lore);
        item.setItemMeta(itemMeta);
        return item;
    }

    public ItemStack toItemStackWithUnbreakableAndItemFlag(ItemFlag ... itemflag) {
        ItemStack item = this.item;
        item.setAmount(this.amount);
        item.setDurability(this.durabilite);
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.spigot().setUnbreakable(true);
        itemMeta.setDisplayName(this.name);
        itemMeta.setLore(this.lore);
        itemMeta.addItemFlags(itemflag);
        item.setItemMeta(itemMeta);
        return item;
    }

    public ItemStack toItemStackwithColorAndUnbreakable(Color color) {
        ItemStack item = this.item;
        LeatherArmorMeta itemMeta = (LeatherArmorMeta)item.getItemMeta();
        itemMeta.spigot().setUnbreakable(true);
        itemMeta.setDisplayName(this.name);
        itemMeta.setLore(this.lore);
        itemMeta.setColor(color);
        item.setItemMeta((ItemMeta)itemMeta);
        item.setAmount(this.amount);
        item.setDurability(this.durabilite);
        return item;
    }

    public ItemStack toSkullValue(String value) {
        ItemStack item = this.item;
        SkullMeta itemMeta = (SkullMeta)item.getItemMeta();
        itemMeta.setDisplayName(this.name);
        itemMeta.setLore(this.lore);
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", value));
        Field profileField = null;
        try {
            profileField = itemMeta.getClass().getDeclaredField("profile");
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        assert (profileField != null);
        profileField.setAccessible(true);
        try {
            profileField.set(itemMeta, profile);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        item.setItemMeta((ItemMeta)itemMeta);
        item.setAmount(this.amount);
        item.setDurability(this.durabilite);
        return item;
    }

    public ItemStack toSkullURL(String skinURL) {
        skinURL = "http://textures.minecraft.net/texture/" + skinURL;
        ItemStack item = this.item;
        SkullMeta itemMeta = (SkullMeta)item.getItemMeta();
        itemMeta.setDisplayName(this.name);
        itemMeta.setLore(this.lore);
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        byte[] encodedData = Base64.encodeBase64((byte[])String.format("{textures:{SKIN:{url:\"%s\"}}}", skinURL).getBytes());
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", new String(encodedData)));
        Field profileField = null;
        try {
            profileField = itemMeta.getClass().getDeclaredField("profile");
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        assert (profileField != null);
        profileField.setAccessible(true);
        try {
            profileField.set(itemMeta, profile);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        item.setItemMeta((ItemMeta)itemMeta);
        item.setAmount(this.amount);
        item.setDurability(this.durabilite);
        return item;
    }

    public ItemStack toItemStackwithSkull(String owner) {
        ItemStack item = this.item;
        SkullMeta itemMeta = (SkullMeta)item.getItemMeta();
        itemMeta.setDisplayName(this.name);
        itemMeta.setLore(this.lore);
        itemMeta.setOwner(owner);
        item.setItemMeta((ItemMeta)itemMeta);
        item.setAmount(this.amount);
        item.setDurability(this.durabilite);
        return item;
    }

    public ItemStack toItemStackwithItemFlag(ItemFlag ... itemflag) {
        ItemStack item = this.item;
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.setDisplayName(this.name);
        itemMeta.setLore(this.lore);
        itemMeta.addItemFlags(itemflag);
        item.setItemMeta(itemMeta);
        item.setAmount(this.amount);
        item.setDurability(this.durabilite);
        return item;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public void setLore(List<String> lore) {
        this.lore = lore;
    }

    public void setLore(String ... lore) {
        ArrayList<String> desc = new ArrayList<String>();
        for (String s : lore) {
            desc.add(s);
            this.lore = desc;
        }
    }

    public void setTexture(String base64) {
        if (!this.item.getType().equals((Object)Material.SKULL_ITEM)) {
            return;
        }
        UUID hashAsId = new UUID(base64.hashCode(), base64.hashCode());
        this.item = Bukkit.getUnsafe().modifyItemStack(this.item, "{SkullOwner:{Id:\"" + hashAsId + "\",Properties:{textures:[{Value:\"" + base64 + "\"}]}}}");
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public void addEnchantement(Enchantment enchant, int level) {
        this.item.addEnchantment(enchant, level);
    }

    public void addUnSafeEnchantement(Enchantment enchant, int level) {
        this.item.addUnsafeEnchantment(enchant, level);
    }

    public void removeEnchantment(Enchantment enchant) {
        this.item.removeEnchantment(enchant);
    }

    public void addGlowEffect() {
        ItemMeta itemMeta = this.item.getItemMeta();
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        itemMeta.addEnchant(Enchantment.DURABILITY, 1, true);
        this.item.setItemMeta(itemMeta);
    }

    public void removeGlowEffect() {
        ItemMeta itemMeta = this.item.getItemMeta();
        itemMeta.removeItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        itemMeta.removeEnchant(Enchantment.DURABILITY);
        this.item.setItemMeta(itemMeta);
    }

    public Map<Enchantment, Integer> getEnchantments() {
        return this.item.getEnchantments();
    }

    public int getDurabilite() {
        return this.durabilite;
    }

    public void setDurabilite(short durabilite) {
        this.durabilite = durabilite;
    }
}

