/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.utils.inventory.event;

import eu.scorpionltd.utils.inventory.item.InteractItem;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import java.util.ListIterator;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class InteractItemEvent
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public void onItemInteract(PlayerInteractEvent e) {
        if (e.getItem() == null) {
            return;
        }
        if (InteractItem.cache.containsKey(e.getItem())) {
            e.setCancelled(true);
            InteractItem item = InteractItem.cache.get(e.getItem());
            item.onClick(ScorpionPlayer.getScorpionPlayer(e.getPlayer().getUniqueId()), e.getAction(), e.getClickedBlock());
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerDrop(PlayerDropItemEvent e) {
        InteractItem item;
        if (e.getItemDrop() == null || e.getItemDrop().getItemStack() == null) {
            return;
        }
        ItemStack stack = e.getItemDrop().getItemStack();
        if (InteractItem.cache.containsKey(stack) && !(item = InteractItem.cache.get(stack)).isDrop()) {
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onMoveChest(InventoryClickEvent e) {
        if (e.getView().getTopInventory() == null || e.getView().getBottomInventory() == null) {
            return;
        }
        Inventory top = e.getView().getTopInventory();
        Inventory bot = e.getView().getBottomInventory();
        if (top.getType() == InventoryType.CHEST || bot.getType() != InventoryType.PLAYER) {
            return;
        }
        if (e.getCurrentItem() == null || e.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        if (!InteractItem.cache.containsKey(e.getCurrentItem()) || InteractItem.cache.get(e.getCurrentItem()).isDrop()) {
            return;
        }
        if (top.getSize() == 27 && e.getRawSlot() > 26) {
            e.setCancelled(true);
            return;
        }
        if (top.getSize() == 54 && e.getRawSlot() > 53) {
            e.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onDeathDrop(PlayerDeathEvent e) {
        if (e.getDrops().isEmpty()) {
            return;
        }
        ListIterator drops = e.getDrops().listIterator();
        while (drops.hasNext()) {
            InteractItem item;
            ItemStack stack = (ItemStack)drops.next();
            if (!InteractItem.cache.containsKey(stack) || (item = InteractItem.cache.get(stack)).isDrop()) continue;
            drops.remove();
        }
    }

    @EventHandler
    public void onInventoryClicke(InventoryClickEvent event) {
        if (event.getCursor() == null) {
            return;
        }
        if (!InteractItem.cache.containsKey(event.getCursor())) {
            return;
        }
        event.setCancelled(true);
    }
}

