/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.utils.inventory;

import eu.scorpionltd.API;
import eu.scorpionltd.utils.inventory.item.ActionItem;
import eu.scorpionltd.utils.inventory.item.StaticItem;
import eu.scorpionltd.utils.item.Item;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class CustomInventory {
    public static Map<UUID, CustomInventory> cache = new ConcurrentHashMap<UUID, CustomInventory>();
    public ScorpionPlayer player;
    public String title;
    public int lines;
    public int categories;
    public List<StaticItem> staticItems;
    public List<ActionItem> actionItems;
    public int actual_categorie;
    public Inventory inv;

    public CustomInventory(ScorpionPlayer p, String title, int lines, int categories) {
        this.player = p;
        this.title = title;
        this.lines = lines;
        this.categories = categories;
        this.staticItems = new ArrayList<StaticItem>();
        this.actionItems = new ArrayList<ActionItem>();
        this.actual_categorie = 1;
    }

    public void openMenu() {
        this.staticItems.clear();
        this.actionItems.clear();
        this.setupMenu();
        this.inv = Bukkit.createInventory(null, (int)this.getSlots(), (String)this.getTitle());
        this.refresh();
    }

    public void openMenuCooldown(int tick) {
        Bukkit.getScheduler().runTaskLater((Plugin)API.getInstance(), new Runnable(){

            @Override
            public void run() {
                CustomInventory.this.openMenu();
            }
        }, (long)tick);
    }

    public void onClose() {
    }

    public void refresh() {
        if (cache.containsKey(this.player.getUUID())) {
            cache.remove(this.player.getUUID());
        }
        for (StaticItem staticItem : this.staticItems) {
            if (staticItem.getCategory() != this.getActualCategorie() && !staticItem.isAllCategories()) continue;
            this.inv.setItem(staticItem.getSlot(), staticItem.getItemStack());
        }
        for (ActionItem actionItem : this.actionItems) {
            if (actionItem.getCategory() != this.getActualCategorie() && !actionItem.isAllCategories()) continue;
            this.inv.setItem(actionItem.getSlot(), actionItem.getItemStack());
        }
        this.player.getPlayer().openInventory(this.inv);
        cache.put(this.player.getUUID(), this);
    }

    public void remplirInventory(ItemStack item) {
        for (int i = 0; i < this.getSlots(); ++i) {
            this.addItem(new StaticItem(i, item));
        }
    }

    public void remplirLignesInventory(ItemStack item, int lignes) {
        for (int i = 9 * (lignes - 1); i < lignes * 9; ++i) {
            this.addItem(new StaticItem(i, item));
        }
    }

    public void remplirCornerInventory(ItemStack item) {
        Arrays.asList(0, 1, 7, 8, 9, 17).forEach(i -> {
            if (i < this.lines * 9) {
                this.addItem(new StaticItem((int)i, item));
            }
        });
        int lastItem = this.lines * 9 - 1;
        Arrays.asList(lastItem, lastItem - 1, lastItem - 7, lastItem - 8, lastItem - 9, lastItem - 17).forEach(i -> {
            if (i < this.lines * 9) {
                this.addItem(new StaticItem((int)i, item));
            }
        });
    }

    public void remplirCadreInventory(ItemStack item) {
        this.remplirLignesInventory(item, 1);
        this.remplirLignesInventory(item, this.lines);
        Arrays.asList(9, 17, 18, 26, 27, 35, 36, 44).forEach(i -> {
            if (i < this.lines * 9) {
                this.addItem(new StaticItem((int)i, item));
            }
        });
    }

    public void remplirInventoryWithSlotException(ItemStack item, List<Integer> slots) {
        for (int i = 0; i < this.getSlots(); ++i) {
            if (slots.contains(i)) continue;
            this.addItem(new StaticItem(i, item));
        }
    }

    public void remplirInventoryWithSlot(ItemStack item, List<Integer> slots) {
        for (Integer s : slots) {
            if (s < 0 || s >= this.lines * 9) continue;
            this.addItem(new StaticItem(s, item));
        }
    }

    public void remplirInventoryWithSlotException(ItemStack item, Integer ... slotException) {
        List<Integer> slots = Arrays.asList(slotException);
        for (int i = 0; i < this.getSlots(); ++i) {
            if (slots.contains(i)) continue;
            this.addItem(new StaticItem(i, item));
        }
    }

    public void addMenuItem(int slot, final CustomInventory customInventory, ItemStack stack, String lore) {
        Item menuItem = new Item(stack);
        if (!lore.equals("")) {
            menuItem.setLore("", lore);
        }
        this.addActionItem(new ActionItem(slot, menuItem.toItemStack()){

            @Override
            public void onClick(InventoryClickEvent e) {
                customInventory.openMenu();
            }
        });
    }

    public void addMenuItem(int slot, CustomInventory customInventory, Material material, String name, String lore) {
        this.addMenuItem(slot, customInventory, new Item(material, name).toItemStack(), lore);
    }

    public void addReturnItem(int slot, final CustomInventory customInventory, String message) {
        Item arrow = new Item(Material.ARROW, message);
        this.addActionItem(new ActionItem(slot, arrow.toItemStack()){

            @Override
            public void onClick(InventoryClickEvent e) {
                customInventory.openMenu();
            }
        });
    }

    public void addReturnItem(int slot, CustomInventory customInventory) {
        this.addReturnItem(slot, customInventory, ChatColor.DARK_GREEN + "Revenir en arri\u00e8re");
    }

    public void addCloseItem(int slot, String message) {
        Item close = new Item(Material.BARRIER, message);
        this.addActionItem(new ActionItem(slot, close.toItemStack()){

            @Override
            public void onClick(InventoryClickEvent e) {
                CustomInventory.this.player.getPlayer().closeInventory();
            }
        });
    }

    public void addCloseItem(int slot) {
        this.addCloseItem(slot, ChatColor.DARK_RED + "\u2716" + ChatColor.RED + "Fermer le menu" + ChatColor.DARK_RED + "\u2716");
    }

    public void addSpecialCategorieItem(final int categorie, int slot, int main_categorie, Item item, String selected, String selection) {
        ArrayList<String> lore = new ArrayList<String>();
        if (item.getLore() != null && !item.getLore().isEmpty()) {
            lore.addAll(item.getLore());
            lore.add(" ");
        }
        if (categorie == this.actual_categorie) {
            lore.add(selected);
            item.addGlowEffect();
        } else {
            lore.add(selection);
        }
        item.setLore(lore);
        this.addActionItem(new ActionItem(main_categorie, slot, item.toItemStack()){

            @Override
            public void onClick(InventoryClickEvent e) {
                CustomInventory.this.setActualCategorie(categorie);
                CustomInventory.this.openMenu();
            }
        });
    }

    public void addSpecialCategorieItem(int categorie, int slot, int main_categorie, Item item) {
        this.addSpecialCategorieItem(categorie, slot, main_categorie, item, ChatColor.GREEN + "" + ChatColor.BOLD + "S\u00e9lectionn\u00e9e", ChatColor.DARK_GRAY + "\u00bb" + ChatColor.WHITE + " S\u00e9lectionner cette cat\u00e9gorie");
    }

    public void addCategorieItem(final int categorie, int slot, Item item, String selected, String selection) {
        ArrayList<String> lore = new ArrayList<String>();
        if (item.getLore() != null && !item.getLore().isEmpty()) {
            lore.addAll(item.getLore());
            lore.add(" ");
        }
        if (categorie == this.actual_categorie) {
            lore.add(selected);
            item.addGlowEffect();
        } else {
            lore.add(selection);
        }
        item.setLore(lore);
        this.addActionItem(new ActionItem(slot, item.toItemStack()){

            @Override
            public void onClick(InventoryClickEvent e) {
                CustomInventory.this.setActualCategorie(categorie);
                CustomInventory.this.openMenu();
            }
        });
    }

    public void addCategorieItem(int categorie, int slot, Item item) {
        this.addCategorieItem(categorie, slot, item, ChatColor.GREEN + "" + ChatColor.BOLD + "S\u00e9lectionn\u00e9e", ChatColor.DARK_GRAY + "\u00bb" + ChatColor.WHITE + " S\u00e9lectionner cette cat\u00e9gorie");
    }

    public void addCategorieItemWithSize(final int categorie, int slot, final int lines, Item item, String selected, String selection) {
        ArrayList<String> lore = new ArrayList<String>();
        if (item.getLore() != null && !item.getLore().isEmpty()) {
            lore.addAll(item.getLore());
            lore.add(" ");
        }
        if (categorie == this.actual_categorie) {
            lore.add(selected);
            item.addGlowEffect();
        } else {
            lore.add(selection);
        }
        item.setLore(lore);
        this.addActionItem(new ActionItem(slot, item.toItemStack()){

            @Override
            public void onClick(InventoryClickEvent e) {
                CustomInventory.this.setActualCategorie(categorie);
                CustomInventory.this.changeLines(lines);
                CustomInventory.this.openMenu();
            }
        });
    }

    public void addCategorieItemWithSize(int categorie, int slot, int lines, Item item) {
        this.addCategorieItemWithSize(categorie, slot, lines, item, ChatColor.GREEN + "" + ChatColor.BOLD + "S\u00e9lectionn\u00e9e", ChatColor.DARK_GRAY + "\u00bb" + ChatColor.WHITE + " S\u00e9lectionner cette cat\u00e9gorie");
    }

    public void addPageCategorieItemWithSize(final List<Integer> categories, int slot, final int lines, Item item, String selected, String selection, String next_page, String previous_page) {
        ArrayList<String> lore = new ArrayList<String>();
        final int max_pages = categories.size();
        if (categories.contains(this.actual_categorie)) {
            int page = 1;
            for (int i = 0; i < max_pages; ++i) {
                if (categories.get(i) != this.actual_categorie) continue;
                page = i + 1;
            }
            item.setName(item.getName() + ChatColor.GRAY + " (Page " + ChatColor.LIGHT_PURPLE + page + ChatColor.GRAY + "/" + ChatColor.DARK_PURPLE + max_pages + ChatColor.GRAY + ")");
            lore.add(next_page);
            lore.add(previous_page);
            lore.add(" ");
            lore.add(selected);
            item.addGlowEffect();
        } else {
            lore.add(selection);
        }
        item.setLore(lore);
        this.addActionItem(new ActionItem(slot, item.toItemStack()){

            @Override
            public void onClick(InventoryClickEvent e) {
                if (categories.contains(CustomInventory.this.actual_categorie)) {
                    int categorie = (Integer)categories.get(0);
                    int page = 1;
                    for (int i = 0; i < max_pages; ++i) {
                        if ((Integer)categories.get(i) != CustomInventory.this.actual_categorie) continue;
                        page = i + 1;
                    }
                    if (e.getClick() == ClickType.LEFT) {
                        categorie = page == max_pages ? ((Integer)categories.get(max_pages - 1)).intValue() : ((Integer)categories.get(page)).intValue();
                    }
                    if (e.getClick() == ClickType.RIGHT) {
                        categorie = page == 1 ? ((Integer)categories.get(0)).intValue() : ((Integer)categories.get(page - 2)).intValue();
                    }
                    CustomInventory.this.setActualCategorie(categorie);
                    CustomInventory.this.openMenu();
                } else {
                    CustomInventory.this.setActualCategorie((Integer)categories.get(0));
                    CustomInventory.this.changeLines(lines);
                    CustomInventory.this.openMenu();
                }
            }
        });
    }

    public void addPageCategorieItemWithSize(List<Integer> categories, int slot, int lines, Item item) {
        this.addPageCategorieItemWithSize(categories, slot, lines, item, ChatColor.GREEN + "" + ChatColor.BOLD + "S\u00e9lectionn\u00e9e", ChatColor.DARK_GRAY + "\u00bb" + ChatColor.WHITE + " S\u00e9lectionner cette cat\u00e9gorie", ChatColor.YELLOW + "Clic-Gauche: " + ChatColor.WHITE + "Aller la page suivante", ChatColor.YELLOW + "Clic-Droit: " + ChatColor.WHITE + "Aller la page pr\u00e9c\u00e9dente");
    }

    public void addPageItem(int slot, String next_page, String previous_page) {
        Item page = new Item(Material.MAP, ChatColor.YELLOW + "Page " + ChatColor.LIGHT_PURPLE + this.getActualCategorie() + ChatColor.GOLD + "/" + ChatColor.DARK_PURPLE + this.getMaxCategories());
        page.setLore(next_page, previous_page);
        page.toItemStackwithItemFlag(ItemFlag.HIDE_POTION_EFFECTS);
        this.addActionItem(new ActionItem(slot, page.toItemStackwithItemFlag(ItemFlag.HIDE_ATTRIBUTES)){

            @Override
            public void onClick(InventoryClickEvent e) {
                if (e.getClick() == ClickType.LEFT) {
                    CustomInventory.this.setActualCategorie(CustomInventory.this.getNextCategorie());
                }
                if (e.getClick() == ClickType.RIGHT) {
                    CustomInventory.this.setActualCategorie(CustomInventory.this.getPreviousCategorie());
                }
                CustomInventory.this.openMenu();
            }
        });
    }

    public void addPageItem(int slot) {
        this.addPageItem(slot, ChatColor.YELLOW + "Clic-Gauche: " + ChatColor.WHITE + "Aller la page suivante", ChatColor.YELLOW + "Clic-Droit: " + ChatColor.WHITE + "Aller la page pr\u00e9c\u00e9dente");
    }

    public void addItem(StaticItem item) {
        this.staticItems.add(item);
    }

    public void addActionItem(ActionItem item) {
        this.actionItems.add(item);
    }

    public ScorpionPlayer getScorpionPlayer() {
        return this.player;
    }

    public String getTitle() {
        return this.title;
    }

    public void changeLines(int lines) {
        this.lines = lines;
    }

    public int getLines() {
        return this.lines;
    }

    public int getSlots() {
        return this.lines * 9;
    }

    public int getMaxCategories() {
        return this.categories;
    }

    public void setActualCategorie(int categorie) {
        this.actual_categorie = categorie;
    }

    public int getActualCategorie() {
        return this.actual_categorie;
    }

    public int getPreviousCategorie() {
        if (this.getActualCategorie() == 1) {
            return 1;
        }
        return this.getActualCategorie() - 1;
    }

    public int getNextCategorie() {
        if (this.getActualCategorie() == this.getMaxCategories()) {
            return this.getMaxCategories();
        }
        return this.getActualCategorie() + 1;
    }

    public StaticItem getStaticItem(int slot) {
        StaticItem item = null;
        for (StaticItem staticItem : this.staticItems) {
            if (staticItem.getCategory() != this.getActualCategorie() && !staticItem.isAllCategories() || staticItem.getSlot() != slot) continue;
            item = staticItem;
        }
        return item;
    }

    public ActionItem getActionItem(int slot) {
        ActionItem item = null;
        for (ActionItem actionItem : this.actionItems) {
            if (actionItem.getCategory() != this.getActualCategorie() && !actionItem.isAllCategories() || actionItem.getSlot() != slot) continue;
            item = actionItem;
        }
        return item;
    }

    public void openMenuAll() {
        ArrayList<CustomInventory> customUI = new ArrayList<CustomInventory>(cache.values());
        customUI.forEach(cui -> {
            if (cui.getTitle().equals(this.title)) {
                cui.openMenu();
            }
        });
    }

    public abstract void setupMenu();
}

