/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.utils.generation;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;

public class VoidGenerator
extends ChunkGenerator {
    private BlockPopulator populator = null;

    public VoidGenerator() {
    }

    public VoidGenerator(final Biome b) {
        this.populator = new BlockPopulator(){

            public void populate(World world, Random rand, Chunk chunk) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        Block block = chunk.getBlock(x, 0, z);
                        block.setBiome(b);
                    }
                }
            }
        };
    }

    public void populate(World world, Chunk chunk) {
        this.populator.populate(world, null, chunk);
    }

    public List<BlockPopulator> getDefaultPopulators(World world) {
        if (this.populator != null) {
            return Arrays.asList(this.populator);
        }
        return Arrays.asList(new BlockPopulator[0]);
    }

    public boolean canSpawn(World world, int x, int z) {
        return true;
    }

    public byte[] generate(World world, Random rand, int chunkx, int chunkz) {
        return new byte[32768];
    }

    public Location getFixedSpawnLocation(World world, Random random) {
        return new Location(world, 0.0, 0.0, 0.0);
    }
}

