/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.utils.firework;

import eu.scorpionltd.utils.UtilLag;
import java.util.Random;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftFirework;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.meta.FireworkMeta;

public class UtilFirework {
    public static Firework playRandomFireworkColor(Location l, FireworkEffect.Type type, int power, boolean instant) {
        if (!UtilLag.serverIsLag()) {
            FireworkEffect.Builder fwB = FireworkEffect.builder();
            Random r = new Random();
            fwB.flicker(r.nextBoolean());
            fwB.trail(r.nextBoolean());
            fwB.with(type);
            fwB.withColor(Color.fromRGB((int)r.nextInt(256), (int)r.nextInt(256), (int)r.nextInt(256)));
            fwB.withFade(Color.fromRGB((int)r.nextInt(256), (int)r.nextInt(256), (int)r.nextInt(256)));
            FireworkEffect fe = fwB.build();
            Firework f = UtilFirework.spawnFirework(l, fe, power, instant);
            return f;
        }
        return null;
    }

    public static Firework playRandomFireworkColor(Location l, int power, boolean instant) {
        if (!UtilLag.serverIsLag()) {
            FireworkEffect.Builder fwB = FireworkEffect.builder();
            Random r = new Random();
            fwB.flicker(r.nextBoolean());
            fwB.trail(r.nextBoolean());
            fwB.with(FireworkEffect.Type.values()[r.nextInt(FireworkEffect.Type.values().length)]);
            fwB.withColor(Color.fromRGB((int)r.nextInt(256), (int)r.nextInt(256), (int)r.nextInt(256)));
            fwB.withFade(Color.fromRGB((int)r.nextInt(256), (int)r.nextInt(256), (int)r.nextInt(256)));
            FireworkEffect fe = fwB.build();
            Firework f = UtilFirework.spawnFirework(l, fe, power, instant);
            return f;
        }
        return null;
    }

    public static Firework spawnFirework(Location location, FireworkEffect effect, int power, boolean instant) {
        if (!UtilLag.serverIsLag()) {
            Entity e = location.getWorld().spawnEntity(location, EntityType.FIREWORK);
            Firework f = (Firework)e;
            FireworkMeta fm = f.getFireworkMeta();
            fm.addEffect(effect);
            if (!instant) {
                fm.setPower(power);
            } else {
                fm.setPower(1);
            }
            f.setFireworkMeta(fm);
            if (instant) {
                ((CraftFirework)f).getHandle().expectedLifespan = 1;
            }
            return f;
        }
        return null;
    }

    public static Firework spawnRandomFirework(Location location, boolean instant) {
        Random r = new Random();
        FireworkEffect effect = FireworkEffect.builder().flicker(r.nextBoolean()).trail(r.nextBoolean()).with(FireworkEffect.Type.values()[r.nextInt(FireworkEffect.Type.values().length)]).withColor(Color.fromRGB((int)r.nextInt(256), (int)r.nextInt(256), (int)r.nextInt(256))).withFade(Color.fromRGB((int)r.nextInt(256), (int)r.nextInt(256), (int)r.nextInt(256))).build();
        int power = r.nextInt(3);
        return UtilFirework.spawnFirework(location, effect, power, instant);
    }
}

