/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.utils.files;

import java.io.File;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class FConfig {
    private JavaPlugin plugin;
    private String fileName;
    private String dir;
    private File file;

    public FConfig(JavaPlugin plugin, String fileName, String dir) {
        this.plugin = plugin;
        this.fileName = fileName + (fileName.endsWith(".yml") ? "" : ".yml");
        this.dir = dir;
        this.createFile();
    }

    public FConfig(JavaPlugin plugin, String fileName) {
        this(plugin, fileName, "");
    }

    public File getFile() {
        return this.file;
    }

    public FileConfiguration getConfig() {
        return YamlConfiguration.loadConfiguration((File)this.getFile());
    }

    public void createFile() {
        try {
            this.file = new File(this.plugin.getDataFolder() + this.dir, this.fileName);
            if (!this.file.exists()) {
                if (this.plugin.getResource(this.fileName) != null) {
                    this.plugin.saveResource(this.fileName, false);
                } else {
                    this.getConfig().save(this.file);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void save(FileConfiguration config) {
        try {
            config.save(this.file);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getFileName() {
        return this.fileName;
    }
}

