/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.utils.entity;

import com.google.common.base.Preconditions;
import eu.scorpionltd.utils.entity.VillagerShop;
import net.minecraft.server.v1_8_R3.EntityHuman;
import net.minecraft.server.v1_8_R3.EntityPlayer;
import net.minecraft.server.v1_8_R3.IChatBaseComponent;
import net.minecraft.server.v1_8_R3.IMerchant;
import net.minecraft.server.v1_8_R3.ItemStack;
import net.minecraft.server.v1_8_R3.MerchantRecipe;
import net.minecraft.server.v1_8_R3.MerchantRecipeList;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_8_R3.util.CraftChatMessage;
import org.bukkit.entity.Player;

public class VillagerTrading {
    public static VillagerShop createShop(String title) {
        return new VillagerShop(title);
    }

    public static void openTrade(Player p, VillagerShop shop) {
        VillagerTrading.openTrade(p, shop.getTitle(), shop.jsonTitle(), shop.getOfferArray());
    }

    public static void openTrade(Player p, String text, boolean json, VillagerTradeOffer ... offers) {
        Merchant merchant = new Merchant(text, json, offers);
        EntityPlayer entityPlayer = ((CraftPlayer)p).getHandle();
        merchant.a_((EntityHuman)entityPlayer);
        entityPlayer.openTrade((IMerchant)merchant);
    }

    public static class Merchant
    implements IMerchant {
        private IChatBaseComponent sendTitle;
        private EntityHuman tradingWith = null;
        private MerchantRecipeList recipeList = new MerchantRecipeList();
        private String title;
        private boolean json;

        public Merchant(String title, boolean json) {
            this.setTitle(title, json);
        }

        public Merchant(String title, boolean json, VillagerTradeOffer ... offers) {
            for (VillagerTradeOffer offer : offers) {
                this.recipeList.add((Object)offer.getMerchantRecipe());
            }
            this.setTitle(title, json);
        }

        public Merchant title(String text, boolean json) {
            this.setTitle(text, json);
            return this;
        }

        public void setTitle(String title, boolean json) {
            IChatBaseComponent newTitle;
            Preconditions.checkNotNull((Object)title, (Object)"title");
            IChatBaseComponent oldTitle = this.sendTitle;
            if (json) {
                try {
                    newTitle = IChatBaseComponent.ChatSerializer.a((String)title);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid json format (" + title + ")", e);
                }
            } else {
                newTitle = CraftChatMessage.fromString((String)title)[0];
            }
            this.sendTitle = newTitle;
            this.json = json;
            this.title = title;
        }

        public void add(VillagerTradeOffer ... offers) {
            for (VillagerTradeOffer offer : offers) {
                this.recipeList.add((Object)offer.getMerchantRecipe());
            }
        }

        public void a_(EntityHuman entityHuman) {
            this.tradingWith = entityHuman;
        }

        public EntityHuman v_() {
            return this.tradingWith;
        }

        public MerchantRecipeList getOffers(EntityHuman entityHuman) {
            return this.recipeList;
        }

        public void a(MerchantRecipe merchantRecipe) {
            this.recipeList.add((Object)merchantRecipe);
        }

        public void a_(ItemStack itemStack) {
        }

        public IChatBaseComponent getScoreboardDisplayName() {
            return this.sendTitle;
        }
    }

    public static class VillagerTradeOffer {
        private ItemStack offer;
        private ItemStack cost1;
        private ItemStack cost2;

        public static VillagerTradeOffer of(ItemStack cost, ItemStack offer) {
            return new VillagerTradeOffer(cost, offer);
        }

        public static VillagerTradeOffer of(ItemStack cost, ItemStack cost2, ItemStack offer) {
            return new VillagerTradeOffer(cost, cost2, offer);
        }

        public VillagerTradeOffer() {
        }

        public VillagerTradeOffer(ItemStack cost, ItemStack offer) {
            this.cost1 = cost;
            this.offer = offer;
        }

        public VillagerTradeOffer(ItemStack cost, ItemStack cost2, ItemStack offer) {
            this.offer = offer;
            this.cost1 = cost;
            this.cost2 = cost2;
        }

        public VillagerTradeOffer offer(ItemStack i) {
            this.offer = i;
            return this;
        }

        public VillagerTradeOffer cost(Slot slot, ItemStack i) {
            if (slot == Slot.FIRST) {
                this.cost1 = i;
            } else {
                this.cost2 = i;
            }
            return this;
        }

        public MerchantRecipe getMerchantRecipe() {
            if (this.cost1 == null || this.offer == null) {
                throw new IllegalArgumentException("cost1 and offer cannot be null");
            }
            if (this.cost2 == null) {
                return new MerchantRecipe(this.cost1, this.offer);
            }
            return new MerchantRecipe(this.cost1, this.cost2, this.offer);
        }

        public static enum Slot {
            FIRST,
            SECOND;

        }
    }
}

