/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.utils.entity;

import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class UtilVelocity {
    public static Vector bumpEntity(Entity entity, double power) {
        Vector bump = entity.getLocation().toVector().add(new Vector(0.0, 1.0, 0.0));
        bump.multiply(power);
        return bump;
    }

    public static void pushEntity(LivingEntity entity, double power) {
        entity.setVelocity(UtilVelocity.getPushVector(entity, power));
    }

    public static void pushEntity(LivingEntity entity, double power, double fixedY) {
        Vector vector = UtilVelocity.getPushVector(entity, power);
        vector.setY(fixedY);
        entity.setVelocity(vector);
    }

    public static void pullEntity(Entity entity, Location to, double power) {
        entity.setVelocity(UtilVelocity.getPullVector(entity, to, power));
    }

    public static void pullEntity(Entity entity, Location to, double power, double fixedY) {
        Vector vector = UtilVelocity.getPullVector(entity, to, power);
        vector.setY(fixedY);
        entity.setVelocity(vector);
    }

    public static Vector getPushVector(LivingEntity entity, double power) {
        Vector bump = entity.getEyeLocation().getDirection().multiply(-1).normalize().multiply(power);
        bump = bump.setY(0);
        return bump;
    }

    public static Vector getPullVector(Entity entity, Location to, double power) {
        Vector pull = to.toVector().subtract(entity.getLocation().toVector()).normalize();
        pull.multiply(power);
        return pull;
    }

    public static Location getLocationInFrontOfPlayer(Player player) {
        World world = player.getWorld();
        Location loc = player.getLocation();
        Block behind = loc.getBlock();
        int direction = (int)loc.getYaw();
        if (direction < 0) {
            direction += 360;
            direction = (direction + 45) / 90;
        } else {
            direction = (direction + 45) / 90;
        }
        switch (direction) {
            case 1: {
                behind = world.getBlockAt(behind.getX() - 1, behind.getY(), behind.getZ());
                break;
            }
            case 2: {
                behind = world.getBlockAt(behind.getX(), behind.getY(), behind.getZ() - 1);
                break;
            }
            case 3: {
                behind = world.getBlockAt(behind.getX() + 1, behind.getY(), behind.getZ());
                break;
            }
            case 4: {
                behind = world.getBlockAt(behind.getX(), behind.getY(), behind.getZ() + 1);
                break;
            }
            case 0: {
                behind = world.getBlockAt(behind.getX(), behind.getY(), behind.getZ() + 1);
            }
        }
        return behind.getLocation();
    }
}

