/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.utils.entity;

import eu.scorpionltd.API;
import eu.scorpionltd.utils.UtilMath;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.v1_8_R3.EntityCreature;
import net.minecraft.server.v1_8_R3.EntityHuman;
import net.minecraft.server.v1_8_R3.EntityInsentient;
import net.minecraft.server.v1_8_R3.EntityLiving;
import net.minecraft.server.v1_8_R3.EntityTracker;
import net.minecraft.server.v1_8_R3.EntityTrackerEntry;
import net.minecraft.server.v1_8_R3.NavigationAbstract;
import net.minecraft.server.v1_8_R3.PathfinderGoal;
import net.minecraft.server.v1_8_R3.PathfinderGoalFloat;
import net.minecraft.server.v1_8_R3.PathfinderGoalSelector;
import net.minecraft.server.v1_8_R3.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_8_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_8_R3.util.UnsafeList;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class UtilEntity {
    private static Field gsa;
    private static Field goalSelector;
    private static Field targetSelector;
    public static HashMap<UUID, Entity> pet;

    public static Entity summon(EntityType type, Location loc) {
        return loc.getWorld().spawnEntity(loc, type);
    }

    public static String getName(Entity en) {
        if (en instanceof LivingEntity) {
            return ((LivingEntity)en).getCustomName();
        }
        return en.getType().name();
    }

    public static void setName(Entity en, String name, boolean visible) {
        if (en instanceof LivingEntity) {
            ((LivingEntity)en).setCustomName(name);
            ((LivingEntity)en).setCustomNameVisible(visible);
        }
    }

    public static Entity[] getNearbyEntities(Location l, int radius) {
        int chunkRadius = radius < 16 ? 1 : (radius - radius % 16) / 16;
        HashSet<Entity> radiusEntities = new HashSet<Entity>();
        for (int chX = 0 - chunkRadius; chX <= chunkRadius; ++chX) {
            for (int chZ = 0 - chunkRadius; chZ <= chunkRadius; ++chZ) {
                int x = (int)l.getX();
                int y = (int)l.getY();
                int z = (int)l.getZ();
                for (Entity e : new Location(l.getWorld(), (double)(x + chX * 16), (double)y, (double)(z + chZ * 16)).getChunk().getEntities()) {
                    if (!(e.getLocation().distance(l) <= (double)radius) || e.getLocation().getBlock() == l.getBlock()) continue;
                    radiusEntities.add(e);
                }
            }
        }
        return (Entity[])radiusEntities.toArray((Object[])new Entity[radiusEntities.size()]);
    }

    public static List<Entity> getNearbyEntitiesList(Location l, int radius) {
        int chunkRadius = radius < 16 ? 1 : (radius - radius % 16) / 16;
        ArrayList<Entity> radiusEntities = new ArrayList<Entity>();
        for (int chX = 0 - chunkRadius; chX <= chunkRadius; ++chX) {
            for (int chZ = 0 - chunkRadius; chZ <= chunkRadius; ++chZ) {
                int x = (int)l.getX();
                int y = (int)l.getY();
                int z = (int)l.getZ();
                for (Entity e : new Location(l.getWorld(), (double)(x + chX * 16), (double)y, (double)(z + chZ * 16)).getChunk().getEntities()) {
                    if (!(e.getLocation().distance(l) <= (double)radius) || e.getLocation().getBlock() == l.getBlock()) continue;
                    radiusEntities.add(e);
                }
            }
        }
        return radiusEntities;
    }

    public static void removeEntity(final Entity e, int time) {
        Bukkit.getScheduler().runTaskLater((Plugin)API.getInstance(), new Runnable(){

            @Override
            public void run() {
                if (e.isValid()) {
                    e.remove();
                }
            }
        }, (long)(time * 10));
    }

    public static void inofensifMob(LivingEntity e) {
        try {
            EntityLiving nms_entity = ((CraftLivingEntity)e).getHandle();
            if (!(nms_entity instanceof EntityInsentient)) {
                throw new IllegalArgumentException("not an instance of an EntityInsentient.");
            }
            PathfinderGoalSelector goal = (PathfinderGoalSelector)goalSelector.get(nms_entity);
            PathfinderGoalSelector target = (PathfinderGoalSelector)targetSelector.get(nms_entity);
            gsa.set(goal, new UnsafeList());
            gsa.set(target, new UnsafeList());
            goal.a(0, (PathfinderGoal)new PathfinderGoalFloat((EntityInsentient)nms_entity));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void entityToRemove(final Entity e, int time) {
        Bukkit.getScheduler().runTaskLater((Plugin)API.getInstance(), new Runnable(){

            @Override
            public void run() {
                if (e.isValid()) {
                    e.remove();
                }
            }
        }, (long)(time * 20));
    }

    public static void updateEntities(List<Player> observers) {
        for (Player player : observers) {
            UtilEntity.updateEntity((Entity)player, observers);
        }
    }

    @Deprecated
    public static void updateEntity(Entity entity, List<Player> observers) {
        World world = entity.getWorld();
        WorldServer worldServer = ((CraftWorld)world).getHandle();
        EntityTracker tracker = worldServer.tracker;
        EntityTrackerEntry entry = (EntityTrackerEntry)tracker.trackedEntities.get(entity.getEntityId());
        List<EntityHuman> nmsPlayers = UtilEntity.getNmsPlayers(observers);
        entry.trackedPlayers.removeAll(nmsPlayers);
        entry.scanPlayers(nmsPlayers);
    }

    private static List<EntityHuman> getNmsPlayers(List<Player> players) {
        ArrayList<EntityHuman> nsmPlayers = new ArrayList<EntityHuman>();
        for (Player bukkitPlayer : players) {
            EntityHuman craftPlayer = (EntityHuman)bukkitPlayer;
            nsmPlayers.add(craftPlayer);
        }
        return nsmPlayers;
    }

    public static List<Player> getEntityWithin(Entity e, int distance) {
        ArrayList<Player> res = new ArrayList<Player>();
        int d2 = distance * distance;
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (p.getWorld() != e.getWorld() || !(p.getLocation().distanceSquared(e.getLocation()) <= (double)d2)) continue;
            res.add(p);
        }
        return res;
    }

    public static void moveCreature(Entity ent, Location target, float speed) {
        if (!(ent instanceof Creature)) {
            return;
        }
        if (UtilMath.offset(ent.getLocation(), target) < 0.1) {
            return;
        }
        EntityCreature ec = ((CraftCreature)ent).getHandle();
        NavigationAbstract nav = ec.getNavigation();
        if (UtilMath.offset(ent.getLocation(), target) > 24.0) {
            Location newTarget = ent.getLocation();
            newTarget.add(UtilEntity.getTrajectory(ent.getLocation(), target).multiply(24));
            nav.a(newTarget.getX(), newTarget.getY(), newTarget.getZ(), (double)speed);
        } else {
            nav.a(target.getX(), target.getY(), target.getZ(), (double)speed);
        }
    }

    public static void moveCreature(final Entity ent, final Location target, float speed, boolean checkLocation) {
        if (!(ent instanceof Creature)) {
            return;
        }
        if (UtilMath.offset(ent.getLocation(), target) < 0.1) {
            return;
        }
        EntityCreature ec = ((CraftCreature)ent).getHandle();
        NavigationAbstract nav = ec.getNavigation();
        new BukkitRunnable(){

            public void run() {
                if (ent.getLocation().distance(target) < 2.0) {
                    // empty if block
                }
            }
        }.runTaskTimer((Plugin)API.getInstance(), 0L, 20L);
        if (UtilMath.offset(ent.getLocation(), target) > 24.0) {
            Location newTarget = ent.getLocation();
            newTarget.add(UtilEntity.getTrajectory(ent.getLocation(), target).multiply(24));
            nav.a(newTarget.getX(), newTarget.getY(), newTarget.getZ(), (double)speed);
        } else {
            nav.a(target.getX(), target.getY(), target.getZ(), (double)speed);
        }
    }

    public static Vector getTrajectory(Entity from, Entity to) {
        return UtilEntity.getTrajectory(from.getLocation().toVector(), to.getLocation().toVector());
    }

    public static Vector getTrajectory(Entity from, Player to) {
        return UtilEntity.getTrajectory(from.getLocation().toVector(), to.getLocation().toVector());
    }

    public static Vector getTrajectory(Location from, Player to) {
        return UtilEntity.getTrajectory(from.toVector(), to.getLocation().toVector());
    }

    public static Vector getTrajectory(Location from, Location to) {
        return UtilEntity.getTrajectory(from.toVector(), to.toVector());
    }

    public static Vector getTrajectory(Vector from, Vector to) {
        return to.subtract(from).normalize();
    }

    public static Vector getTrajectory2d(Entity from, Entity to) {
        return UtilEntity.getTrajectory2d(from.getLocation().toVector(), to.getLocation().toVector());
    }

    public static Vector getTrajectory2d(Location from, Location to) {
        return UtilEntity.getTrajectory2d(from.toVector(), to.toVector());
    }

    public static Vector getTrajectory2d(Vector from, Vector to) {
        return to.subtract(from).setY(0).normalize();
    }

    static {
        pet = new HashMap();
        try {
            gsa = PathfinderGoalSelector.class.getDeclaredField("b");
            gsa.setAccessible(true);
            goalSelector = EntityInsentient.class.getDeclaredField("goalSelector");
            goalSelector.setAccessible(true);
            targetSelector = EntityInsentient.class.getDeclaredField("targetSelector");
            targetSelector.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

