/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.utils.bungee;

import com.google.common.collect.Iterables;
import eu.scorpionltd.utils.bungee.BungeeSubChannel;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public enum BungeeChannel {
    BUNGEECORD("BungeeCord"),
    SCORPIONLTD_UHC("ScorpionLTD-UHC"),
    SCORPIONLTD_MODO("ScorpionLTD-Modo"),
    SCORPIONLTD_LOBBY("ScorpionLTD-Lobby"),
    SCORPIONLTD_RANK("ScorpionLTD-Rank");

    private String channelName;

    private BungeeChannel(String channelName) {
        this.channelName = channelName;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public boolean isChannel(String channel) {
        return this.channelName.equals(channel);
    }

    public void registerIncomingChannel(Plugin plugin, PluginMessageListener listener) {
        Bukkit.getServer().getMessenger().registerIncomingPluginChannel(plugin, this.channelName, listener);
    }

    public void registerOutgoingChannel(Plugin plugin) {
        Bukkit.getServer().getMessenger().registerOutgoingPluginChannel(plugin, this.channelName);
    }

    public void sendStringMessageChannel(Plugin plugin, Player sender, BungeeSubChannel sub, String ... stringValues) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(b);
        try {
            out.writeUTF(sub.getSubChannelName());
            for (String object : stringValues) {
                out.writeUTF(object);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (sender == null) {
            sender = (Player)Iterables.getFirst((Iterable)Bukkit.getOnlinePlayers(), null);
        }
        sender.sendPluginMessage(plugin, this.channelName, b.toByteArray());
    }
}

