/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.utils.bdd;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPoolConfig;

public class Redis {
    private JedisCluster jedis;
    private String pass;
    private Set<HostAndPort> sentinels = new HashSet<HostAndPort>();

    public Redis(String host, String pass, int port) {
        this.pass = pass;
        this.sentinels.add(new HostAndPort(host, port));
    }

    public Redis(String host, String pass, List<Integer> port) {
        this.pass = pass;
        port.forEach(p -> this.sentinels.add(new HostAndPort(host, (int)p)));
    }

    public int initPool() {
        return this.setupRedis();
    }

    public void closePool() {
        this.jedis.close();
        this.jedis = null;
    }

    private int setupRedis() {
        if (this.jedis != null) {
            this.jedis.close();
        }
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(3000);
        poolConfig.setMaxWaitMillis(1000L);
        poolConfig.setMinIdle(15);
        poolConfig.setMaxIdle(25);
        poolConfig.setBlockWhenExhausted(false);
        this.jedis = new JedisCluster(this.sentinels, 2000, 2000, 2, this.getPass(), (GenericObjectPoolConfig)poolConfig);
        if (this.jedis == null) {
            return 0;
        }
        return 1;
    }

    public JedisCluster getJedis() {
        if (this.jedis == null) {
            this.setupRedis();
        }
        return this.jedis;
    }

    public boolean isValue(String key) {
        return this.getJedis().exists(key) != false;
    }

    public String getPass() {
        return this.pass;
    }
}

