/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.utils.bdd;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import org.bson.Document;
import org.bson.conversions.Bson;

public class Mongo {
    private MongoCollection<Document> collection;
    private MongoClient client;
    private MongoDatabase database;
    private String host;
    private String db;
    private String clt;
    private String user;
    private String pass;
    private int port;

    public Mongo(String host, String database, String collection, String user, String pass, int port) {
        this.host = host;
        this.db = database;
        this.clt = collection;
        this.user = user;
        this.pass = pass;
        this.port = port;
    }

    public int initPool() {
        return this.setupConnectionMongo();
    }

    public void closePool() {
        this.getClient().close();
    }

    private int setupConnectionMongo() {
        MongoClientURI uri = new MongoClientURI("mongodb://" + this.getUser() + ":" + this.getPass() + "@" + this.getHost() + ":" + this.getPort() + "/admin?retryWrites=true&w=majority");
        this.client = new MongoClient(uri);
        this.database = this.client.getDatabase(this.db);
        this.collection = this.database.getCollection(this.getClt());
        if (this.client == null) {
            return 0;
        }
        return 1;
    }

    public Document getDocumentByUniqueId(String uuid) {
        Bson filter = Filters.eq("_id", uuid);
        return (Document)this.getCollection().find(filter).first();
    }

    public void sendRequest(Object value, String where, String uuid) {
        Bson filter = Filters.eq("_id", uuid);
        Bson request = Updates.set(where, value);
        this.getCollection().updateOne(filter, request);
    }

    public int getPort() {
        return this.port;
    }

    public String getClt() {
        return this.clt;
    }

    public String getDb() {
        return this.db;
    }

    public MongoClient getClient() {
        return this.client;
    }

    public MongoCollection<Document> getCollection() {
        return this.collection;
    }

    public MongoDatabase getDatabase() {
        return this.database;
    }

    public String getHost() {
        return this.host;
    }

    public String getPass() {
        return this.pass;
    }

    public String getUser() {
        return this.user;
    }
}

