/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.utils;

import eu.scorpionltd.utils.UtilMath;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class UtilTime {
    public static final String DATE_FORMAT_NOW = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_DAY = "yyyy-MM-dd";

    public static String secFormat(Integer time) {
        Integer tmin;
        Integer sec = time % 60;
        Integer min = tmin = Integer.valueOf((time - sec) / 60);
        String h = "";
        if (min > 60) {
            min = tmin % 60;
            Integer hour = (tmin - min) / 60;
            h = hour + ":";
        }
        return h + String.format("%02d", min) + ":" + String.format("%02d", sec);
    }

    public static String millisFormat(Long time) {
        Long tmin;
        Long milli = time % 1000L;
        Long tsec = (time - milli) / 1000L;
        Long sec = tsec % 60L;
        Long min = tmin = Long.valueOf((time - sec) / 60L);
        String h = "";
        if (min > 60L) {
            min = tmin % 60L;
            Long hour = (tmin - min) / 60L;
            h = hour + ":";
        }
        return h + String.format("%02d", min) + ":" + String.format("%02d", sec);
    }

    public static String now() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_NOW);
        return sdf.format(cal.getTime());
    }

    public static String when(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_NOW);
        return sdf.format(time);
    }

    public static String date() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_DAY);
        return sdf.format(cal.getTime());
    }

    public static String since(long epoch) {
        return "Took " + UtilTime.convertString(System.currentTimeMillis() - epoch, 1, TimeUnit.FIT) + ".";
    }

    public static double convert(long time, int trim, TimeUnit type) {
        if (type == TimeUnit.FIT) {
            type = time < 60000L ? TimeUnit.SECONDS : (time < 3600000L ? TimeUnit.MINUTES : (time < 86400000L ? TimeUnit.HOURS : TimeUnit.DAYS));
        }
        if (type == TimeUnit.DAYS) {
            return UtilMath.trim(trim, (double)time / 8.64E7);
        }
        if (type == TimeUnit.HOURS) {
            return UtilMath.trim(trim, (double)time / 3600000.0);
        }
        if (type == TimeUnit.MINUTES) {
            return UtilMath.trim(trim, (double)time / 60000.0);
        }
        if (type == TimeUnit.SECONDS) {
            return UtilMath.trim(trim, (double)time / 1000.0);
        }
        return UtilMath.trim(trim, time);
    }

    public static String makeStr(long time) {
        return UtilTime.convertString(time, 1, TimeUnit.FIT);
    }

    public static String makeStr(long time, int trim) {
        return UtilTime.convertString(time, trim, TimeUnit.FIT);
    }

    public static String convertString(long time, int trim, TimeUnit type) {
        if (time == -1L) {
            return "Permanent";
        }
        if (type == TimeUnit.FIT) {
            type = time < 60000L ? TimeUnit.SECONDS : (time < 3600000L ? TimeUnit.MINUTES : (time < 86400000L ? TimeUnit.HOURS : TimeUnit.DAYS));
        }
        if (type == TimeUnit.DAYS) {
            if (UtilMath.trim(trim, (double)time / 8.64E7) < 2.0) {
                return UtilMath.trim(trim, (double)time / 8.64E7) + " jour";
            }
            return UtilMath.trim(trim, (double)time / 8.64E7) + " jours";
        }
        if (type == TimeUnit.HOURS) {
            if (UtilMath.trim(trim, (double)time / 3600000.0) < 2.0) {
                return UtilMath.trim(trim, (double)time / 3600000.0) + " heure";
            }
            return UtilMath.trim(trim, (double)time / 3600000.0) + " heures";
        }
        if (type == TimeUnit.MINUTES) {
            if (UtilMath.trim(trim, (double)time / 60000.0) < 2.0) {
                return UtilMath.trim(trim, (double)time / 60000.0) + " minute";
            }
            return UtilMath.trim(trim, (double)time / 60000.0) + " minutes";
        }
        if (type == TimeUnit.SECONDS) {
            if (UtilMath.trim(trim, (double)time / 1000.0) < 2.0) {
                return UtilMath.trim(trim, (double)time / 1000.0) + " seconde";
            }
            return UtilMath.trim(trim, (double)time / 1000.0) + " secondes";
        }
        if (UtilMath.trim(trim, time) < 2.0) {
            return UtilMath.trim(trim, time) + " milliseconde";
        }
        return UtilMath.trim(trim, time) + " millisecondes";
    }

    public static boolean elapsed(long from, long required) {
        return System.currentTimeMillis() - from > required;
    }

    public static Date parseTimeString(String timeString) throws ParseException {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("mm'm'ss's'");
            Date length = formatter.parse(timeString);
            return length;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static enum TimeUnit {
        FIT,
        DAYS,
        HOURS,
        MINUTES,
        SECONDS,
        MILLISECONDS;

    }
}

