/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.utils;

import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class UtilMath {
    public static final float PI = (float)Math.PI;
    public static final float degreesToRadians = (float)Math.PI / 180;
    public static Random random = new Random();

    public static double trim(int degree, double d) {
        String format = "#.#";
        for (int i = 1; i < degree; ++i) {
            format = format + "#";
        }
        DecimalFormat twoDForm = new DecimalFormat(format);
        return Double.valueOf(twoDForm.format(d));
    }

    public static int rand(int i, int j) {
        return random.nextInt(j - i + 1) + i;
    }

    public static double offset2d(Entity a, Entity b) {
        return UtilMath.offset2d(a.getLocation().toVector(), b.getLocation().toVector());
    }

    public static double offset2d(Location a, Location b) {
        return UtilMath.offset2d(a.toVector(), b.toVector());
    }

    public static double offset2d(Vector a, Vector b) {
        a.setY(0);
        b.setY(0);
        return a.subtract(b).length();
    }

    public static double offset(Entity a, Entity b) {
        return UtilMath.offset(a.getLocation().toVector(), b.getLocation().toVector());
    }

    public static double offset(Location a, Location b) {
        return UtilMath.offset(a.toVector(), b.toVector());
    }

    public static double offset(Vector a, Vector b) {
        return a.subtract(b).length();
    }

    public static double arrondir(double value, int n) {
        double r = (double)Math.round(value * Math.pow(10.0, n)) / Math.pow(10.0, n);
        return r;
    }

    public static double doubleRandomInclusive(double max, double min) {
        double r;
        if (max < min) {
            double tmp = min;
            min = max;
            max = tmp;
        }
        if ((r = Math.random()) < 0.5) {
            return (1.0 - Math.random()) * (max - min) + min;
        }
        return Math.random() * (max - min) + min;
    }

    public static int integerRandomInclusive(int max, int min) {
        if (max < min) {
            int tmp = min;
            min = max;
            max = tmp;
        }
        return (int)(Math.random() * (double)(max - min) + (double)min);
    }

    public static Set<Vector> getCircle(Double radius, Integer amount, Boolean full, Double space) {
        Double z;
        Double x;
        HashSet<Vector> list = new HashSet<Vector>();
        Double increment = Math.PI * 2 / (double)amount.intValue();
        Double angle = 0.0;
        while (angle <= Math.PI * 2) {
            x = radius * Math.cos(angle);
            z = radius * Math.sin(angle);
            list.add(new Vector(x.intValue(), 0, z.intValue()));
            angle = angle + increment;
        }
        if (full.booleanValue()) {
            while (radius > 0.0) {
                radius = radius - space;
                angle = 0.0;
                while (angle <= Math.PI * 2) {
                    x = radius * Math.cos(angle);
                    z = radius * Math.sin(angle);
                    list.add(new Vector(x.intValue(), 0, z.intValue()));
                    angle = angle + increment;
                }
            }
        }
        return list;
    }
}

