/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.utils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.bukkit.ChatColor;

public class TimeParser {
    public static String convertTimeToDate(Long mt) {
        Date date = new Date(mt);
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy  HH:mm");
        return format.format(date);
    }

    public static long parseString(String string) {
        if (string.equalsIgnoreCase("perm") || string.equalsIgnoreCase("permanent") || string.equalsIgnoreCase("def") || string.equalsIgnoreCase("definitif")) {
            return -1L;
        }
        ArrayList<String> list = new ArrayList<String>();
        int goBack = 0;
        for (int i = 0; i < string.length(); ++i) {
            String c = String.valueOf(string.charAt(i));
            if (!c.matches("[a-zA-Z]")) continue;
            list.add(string.substring(goBack, i + 1));
            goBack = i + 1;
        }
        long total = 0L;
        for (String st : list) {
            char ch = st.charAt(st.length() - 1);
            if (st.length() == 1 || !String.valueOf(ch).matches("[M,w,d,h,m,s]")) continue;
            long amount = Math.abs(Integer.parseInt(st.substring(0, st.length() - 1)));
            switch (ch) {
                case 's': {
                    total += amount * 1000L;
                }
                case 'm': {
                    total += amount * 1000L * 60L;
                }
                case 'h': {
                    total += amount * 1000L * 3600L;
                }
                case 'd': {
                    total += amount * 1000L * 3600L * 24L;
                }
                case 'w': {
                    total += amount * 1000L * 3600L * 24L * 7L;
                }
            }
        }
        if (total == 0L) {
            return -1L;
        }
        return total;
    }

    public static String parseLong(long milliseconds, boolean abbreviate) {
        ArrayList<String> units = new ArrayList<String>();
        long amount = milliseconds / 604800000L;
        units.add(amount + "w");
        amount = milliseconds / 86400000L % 7L;
        units.add(amount + "d");
        amount = milliseconds / 3600000L % 24L;
        units.add(amount + "h");
        amount = milliseconds / 60000L % 60L;
        units.add(amount + "m");
        amount = milliseconds / 1000L % 60L;
        units.add(amount + "s");
        String[] array = new String[5];
        for (String s : units) {
            int end = s.charAt(s.length() - 1);
            switch (end) {
                case 119: {
                    array[0] = s;
                }
                case 100: {
                    array[1] = s;
                }
                case 104: {
                    array[2] = s;
                }
                case 109: {
                    array[3] = s;
                }
                case 115: {
                    array[4] = s;
                }
            }
        }
        units.clear();
        for (String s : array) {
            if (s.startsWith("0")) continue;
            units.add(s);
        }
        StringBuilder sb = new StringBuilder();
        for (String s : units) {
            if (!abbreviate) {
                String word;
                char c = s.charAt(s.length() - 1);
                String count = s.substring(0, s.length() - 1);
                switch (c) {
                    case 'w': {
                        word = "semaine" + (count.equals("1") ? "" : "s");
                        break;
                    }
                    case 'd': {
                        word = "jour" + (count.equals("1") ? "" : "s");
                        break;
                    }
                    case 'h': {
                        word = "heure" + (count.equals("1") ? "" : "s");
                        break;
                    }
                    case 'm': {
                        word = "minute" + (count.equals("1") ? "" : "s");
                        break;
                    }
                    default: {
                        word = "seconde" + (count.equals("1") ? "" : "s");
                    }
                }
                String and = s.equals(units.get(units.size() - 1)) ? "" : (s.equals(units.get(units.size() - 2)) ? " et " : ", ");
                sb.append(count).append(" ").append(word).append(and);
                continue;
            }
            sb.append(s);
            if (s.equals(units.get(units.size() - 1))) continue;
            sb.append("-");
        }
        return sb.toString().trim().length() == 0 ? null : sb.toString().trim();
    }

    public static String getTimeString(Long mt) {
        if (mt == null) {
            return "Null";
        }
        String time = "";
        if (mt == -1L) {
            return "D\u00e9finitivement";
        }
        long seconds = mt % 60L;
        long minutes = mt / 60L % 60L;
        long hours = mt / 60L / 60L % 24L;
        long days = mt / 60L / 60L / 24L % 365L;
        long years = mt / 60L / 60L / 24L / 365L;
        if (years > 0L) {
            time = years < 2L ? time + " " + ChatColor.DARK_RED + years + ChatColor.RED + " an" : time + " " + ChatColor.DARK_RED + years + ChatColor.RED + " ans";
        }
        if (days > 0L) {
            time = days < 2L ? time + " " + ChatColor.DARK_RED + days + ChatColor.RED + " jour" : time + " " + ChatColor.DARK_RED + days + ChatColor.RED + " jours";
        }
        if (hours > 0L && years <= 0L) {
            time = hours < 2L ? time + " " + ChatColor.DARK_RED + hours + ChatColor.RED + " heure" : time + " " + ChatColor.DARK_RED + hours + ChatColor.RED + " heures";
        }
        if (minutes > 0L && days <= 0L) {
            time = minutes < 2L ? time + " " + ChatColor.DARK_RED + minutes + ChatColor.RED + " minute" : time + " " + ChatColor.DARK_RED + minutes + ChatColor.RED + " minutes";
        }
        if (seconds > 0L && hours <= 0L) {
            time = seconds < 2L ? time + " " + ChatColor.DARK_RED + seconds + ChatColor.RED + " seconde" : time + " " + ChatColor.DARK_RED + seconds + ChatColor.RED + " secondes";
        }
        if (time.isEmpty()) {
            time = time + " " + ChatColor.DARK_RED + seconds + ChatColor.RED + " seconde";
        }
        return time;
    }
}

