/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.utils;

import eu.scorpionltd.API;
import eu.scorpionltd.utils.schematics.ByteArrayTag;
import eu.scorpionltd.utils.schematics.CompoundTag;
import eu.scorpionltd.utils.schematics.DataException;
import eu.scorpionltd.utils.schematics.IntTag;
import eu.scorpionltd.utils.schematics.ListTag;
import eu.scorpionltd.utils.schematics.NBTInputStream;
import eu.scorpionltd.utils.schematics.NamedTag;
import eu.scorpionltd.utils.schematics.ShortTag;
import eu.scorpionltd.utils.schematics.Tag;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import net.minecraft.server.v1_8_R3.BlockPosition;
import net.minecraft.server.v1_8_R3.NBTBase;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class Schematic {
    private File schematicFile;
    private Method nbtCreateTagMethod;
    private BukkitTask paste;
    private BukkitTask undo;
    private Listener listener;
    private short width;
    private short length;
    private short height;
    private byte[] blockData;
    private short[] blocks;
    private List<BlockInfo> blockInfos = new ArrayList<BlockInfo>();
    private List<BlockInfo> blockRemove = new ArrayList<BlockInfo>();

    public Schematic(File file) {
        try {
            this.schematicFile = file;
            this.nbtCreateTagMethod = NBTBase.class.getDeclaredMethod("createTag", Byte.TYPE);
            this.nbtCreateTagMethod.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void load() {
        try {
            System.out.println("Pasting " + this.schematicFile.getAbsolutePath() + "...");
            if (!this.schematicFile.exists()) {
                System.out.println("Schematic File Not Found");
                return;
            }
            NBTInputStream nbtStream = new NBTInputStream(new GZIPInputStream(new FileInputStream(this.schematicFile)));
            NamedTag rootTag = nbtStream.readNamedTag();
            nbtStream.close();
            if (!rootTag.getName().equals("Schematic")) {
                throw new DataException("Tag \"Schematic\" does not exist or is not first");
            }
            CompoundTag schematicTag = (CompoundTag)rootTag.getTag();
            Object schematic = schematicTag.getValue();
            if (!schematic.containsKey("Blocks")) {
                throw new DataException("Schematic file is missing a \"Blocks\" tag");
            }
            this.width = this.getChildTag((Map<String, Tag>)schematic, "Width", ShortTag.class).getValue();
            this.length = this.getChildTag((Map<String, Tag>)schematic, "Length", ShortTag.class).getValue();
            this.height = this.getChildTag((Map<String, Tag>)schematic, "Height", ShortTag.class).getValue();
            byte[] blockId = this.getChildTag((Map<String, Tag>)schematic, "Blocks", ByteArrayTag.class).getValue();
            this.blockData = this.getChildTag((Map<String, Tag>)schematic, "Data", ByteArrayTag.class).getValue();
            byte[] addId = new byte[]{};
            this.blocks = new short[blockId.length];
            if (schematic.containsKey("AddBlocks")) {
                addId = this.getChildTag((Map<String, Tag>)schematic, "AddBlocks", ByteArrayTag.class).getValue();
            }
            for (int index = 0; index < blockId.length; ++index) {
                this.blocks[index] = index >> 1 >= addId.length ? (short)(blockId[index] & 0xFF) : ((index & 1) == 0 ? (short)(((addId[index >> 1] & 0xF) << 8) + (blockId[index] & 0xFF)) : (short)(((addId[index >> 1] & 0xF0) << 4) + (blockId[index] & 0xFF)));
            }
            Object tileEntities = this.getChildTag((Map<String, Tag>)schematic, "TileEntities", ListTag.class).getValue();
            HashMap tileEntitiesMap = new HashMap();
            Iterator iterator = tileEntities.iterator();
            while (iterator.hasNext()) {
                Tag tag = (Tag)iterator.next();
                if (!(tag instanceof CompoundTag)) continue;
                CompoundTag t = (CompoundTag)tag;
                int x = 0;
                int y = 0;
                int z = 0;
                HashMap values = new HashMap();
                for (Map.Entry entry : t.getValue().entrySet()) {
                    if (((String)entry.getKey()).equals("x")) {
                        if (entry.getValue() instanceof IntTag) {
                            x = ((IntTag)entry.getValue()).getValue();
                        }
                    } else if (((String)entry.getKey()).equals("y")) {
                        if (entry.getValue() instanceof IntTag) {
                            y = ((IntTag)entry.getValue()).getValue();
                        }
                    } else if (((String)entry.getKey()).equals("z") && entry.getValue() instanceof IntTag) {
                        z = ((IntTag)entry.getValue()).getValue();
                    }
                    values.put(entry.getKey(), entry.getValue());
                }
                BlockPosition vec = new BlockPosition(x, y, z);
                tileEntitiesMap.put(vec, values);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void undo(final int blockseconds) {
        final ArrayList<BlockInfo> blockInfos1 = new ArrayList<BlockInfo>(this.blockInfos);
        final ArrayList<BlockInfo> blockRemove1 = new ArrayList<BlockInfo>(this.blockRemove);
        final long start = System.currentTimeMillis();
        this.undo = Bukkit.getScheduler().runTaskTimer((Plugin)API.getInstance(), new BukkitRunnable(){

            public void run() {
                if (blockInfos1.size() != 0) {
                    for (int i = 0; i < blockseconds && blockInfos1.size() != 0; ++i) {
                        int random = new Random().nextInt(blockInfos1.size());
                        BlockInfo blockInfo = (BlockInfo)blockInfos1.remove(random);
                        blockInfo.location.getBlock().setType(Material.AIR);
                    }
                } else {
                    System.out.println("Undo successfully in " + (System.currentTimeMillis() - start) + " milliseconds.");
                    HandlerList.unregisterAll((Listener)Schematic.this.listener);
                    for (BlockInfo b : blockRemove1) {
                        b.location.getBlock().setType(b.material);
                    }
                    Schematic.this.undo.cancel();
                }
            }
        }, 0L, 20L);
    }

    public void paste(Location loc, final int blockseconds, SchematicEvent event) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.length; ++z) {
                    int index = y * this.width * this.length + z * this.width + x;
                    Location l = new Location(loc.getWorld(), (double)x + loc.getX(), (double)y + loc.getY(), (double)z + loc.getZ());
                    byte d = this.blockData[index];
                    Material m = Material.getMaterial((int)this.blocks[index]);
                    if (m == Material.AIR && l.getBlock().getType() == Material.AIR) {
                        this.blockRemove.add(new BlockInfo(m, l, d));
                        continue;
                    }
                    this.blockInfos.add(new BlockInfo(m, l, d));
                }
            }
        }
        this.listener = new Listener(){

            @EventHandler
            public void gravity(BlockPhysicsEvent event) {
                event.setCancelled(true);
            }
        };
        Bukkit.getPluginManager().registerEvents(this.listener, (Plugin)API.getInstance());
        final ArrayList<BlockInfo> blockInfos1 = new ArrayList<BlockInfo>(this.blockInfos);
        System.out.println("Starting paste of " + this.width * this.height * this.length + " blocks");
        final long start = System.currentTimeMillis();
        final SchematicEvent finalEvent = event;
        this.paste = Bukkit.getScheduler().runTaskTimer((Plugin)API.getInstance(), new BukkitRunnable(){

            public void run() {
                if (blockInfos1.size() != 0) {
                    for (int i = 0; i < blockseconds && blockInfos1.size() != 0; ++i) {
                        int random = new Random().nextInt(blockInfos1.size());
                        BlockInfo blockInfo = (BlockInfo)blockInfos1.remove(random);
                        blockInfo.location.getBlock().setTypeIdAndData(blockInfo.material.getId(), blockInfo.data, false);
                        finalEvent.onPaste(blockInfo);
                    }
                } else {
                    System.out.println("Pasted successfully in " + (System.currentTimeMillis() - start) + " milliseconds.");
                    finalEvent.onPasteEnd(Schematic.this.width, Schematic.this.length);
                    HandlerList.unregisterAll((Listener)Schematic.this.listener);
                    Schematic.this.paste.cancel();
                }
            }
        }, 0L, 20L);
    }

    private <T extends Tag> T getChildTag(Map<String, Tag> items, String key, Class<T> expected) throws IllegalArgumentException {
        if (!items.containsKey(key)) {
            throw new IllegalArgumentException("Schematic file is missing a \"" + key + "\" tag");
        }
        Tag tag = items.get(key);
        if (!expected.isInstance(tag)) {
            throw new IllegalArgumentException(key + " tag is not of tag type " + expected.getName());
        }
        return (T)((Tag)expected.cast(tag));
    }

    public short getHeight() {
        return this.height;
    }

    public short getLength() {
        return this.length;
    }

    public short getWidth() {
        return this.width;
    }

    public List<BlockInfo> getBlockInfos() {
        return this.blockInfos;
    }

    public static class BlockInfo {
        public Material material;
        public byte data;
        public Location location;

        public BlockInfo(Material mat, byte data) {
            this.material = mat;
            this.data = data;
        }

        public BlockInfo(Material mat, Location loc, byte data) {
            this.material = mat;
            this.location = loc;
            this.data = data;
        }
    }

    public static interface SchematicEvent {
        public BlockInfo onPaste(BlockInfo var1);

        public void onPasteEnd(Short var1, Short var2);

        public void onFileNotFound();
    }
}

