/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateUtils {
    private static Pattern timePattern = Pattern.compile("(?:([0-9]+)\\s*y[a-z]*[,\\s]*)?(?:([0-9]+)\\s*mo[a-z]*[,\\s]*)?(?:([0-9]+)\\s*w[a-z]*[,\\s]*)?(?:([0-9]+)\\s*d[a-z]*[,\\s]*)?(?:([0-9]+)\\s*h[a-z]*[,\\s]*)?(?:([0-9]+)\\s*m[a-z]*[,\\s]*)?(?:([0-9]+)\\s*(?:s[a-z]*)?)?", 2);

    public static String removeTimePattern(String input) {
        return timePattern.matcher(input).replaceFirst("").trim();
    }

    public static String ticksToString(long ticks) {
        int hours = (int)Math.floor((double)ticks / 3600.0);
        int minutes = (int)Math.floor((double)(ticks -= (long)hours * 3600L) / 60.0);
        int seconds = (int)(ticks -= (long)minutes * 60L);
        StringBuilder output = new StringBuilder();
        if (hours > 0) {
            output.append(hours).append('h');
            if (minutes == 0) {
                output.append(minutes).append('m');
            }
        }
        if (minutes > 0) {
            output.append(minutes).append('m');
        }
        output.append(seconds).append('s');
        return output.toString();
    }

    public static String advancedTicksToString(long ticks) {
        int hours = (int)Math.floor((double)ticks / 3600.0);
        int minutes = (int)Math.floor((double)(ticks -= (long)hours * 3600L) / 60.0);
        int seconds = (int)(ticks -= (long)minutes * 60L);
        StringBuilder output = new StringBuilder();
        if (hours > 0) {
            output.append(hours).append(" ").append(hours == 1 ? "heure\u00a77." : "heures\u00a77.");
        }
        if (minutes > 0) {
            if (output.length() > 0) {
                output.append(" \u00a77et\u00a7a ");
            }
            output.append(minutes).append(" ").append(minutes == 1 ? "minute\u00a77." : "minutes\u00a77.");
        }
        if (seconds > 0) {
            if (output.length() > 0) {
                output.append(" \u00a77and\u00a7a ");
            }
            output.append(seconds).append(" ").append(seconds == 1 ? "seconde\u00a77." : "secondes\u00a77.");
        }
        return output.toString();
    }

    public static long parseDateDiff(String time, boolean future) {
        Matcher m = timePattern.matcher(time);
        int years = 0;
        int months = 0;
        int weeks = 0;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        boolean found = false;
        while (m.find()) {
            if (m.group() == null || m.group().isEmpty()) continue;
            for (int i = 0; i < m.groupCount(); ++i) {
                if (m.group(i) == null || m.group(i).isEmpty()) continue;
                found = true;
                break;
            }
            if (!found) continue;
            if (m.group(1) != null && !m.group(1).isEmpty()) {
                years = Integer.parseInt(m.group(1));
            }
            if (m.group(2) != null && !m.group(2).isEmpty()) {
                months = Integer.parseInt(m.group(2));
            }
            if (m.group(3) != null && !m.group(3).isEmpty()) {
                weeks = Integer.parseInt(m.group(3));
            }
            if (m.group(4) != null && !m.group(4).isEmpty()) {
                days = Integer.parseInt(m.group(4));
            }
            if (m.group(5) != null && !m.group(5).isEmpty()) {
                hours = Integer.parseInt(m.group(5));
            }
            if (m.group(6) != null && !m.group(6).isEmpty()) {
                minutes = Integer.parseInt(m.group(6));
            }
            if (m.group(7) == null || m.group(7).isEmpty()) break;
            seconds = Integer.parseInt(m.group(7));
            break;
        }
        if (!found) {
            return 0L;
        }
        GregorianCalendar c = new GregorianCalendar();
        if (years > 0) {
            ((Calendar)c).add(1, years * (future ? 1 : -1));
        }
        if (months > 0) {
            ((Calendar)c).add(2, months * (future ? 1 : -1));
        }
        if (weeks > 0) {
            ((Calendar)c).add(3, weeks * (future ? 1 : -1));
        }
        if (days > 0) {
            ((Calendar)c).add(5, days * (future ? 1 : -1));
        }
        if (hours > 0) {
            ((Calendar)c).add(11, hours * (future ? 1 : -1));
        }
        if (minutes > 0) {
            ((Calendar)c).add(12, minutes * (future ? 1 : -1));
        }
        if (seconds > 0) {
            ((Calendar)c).add(13, seconds * (future ? 1 : -1));
        }
        GregorianCalendar max = new GregorianCalendar();
        ((Calendar)max).add(1, 10);
        return c.after(max) ? max.getTimeInMillis() : c.getTimeInMillis();
    }

    static int dateDiff(int type, Calendar fromDate, Calendar toDate, boolean future) {
        int diff = 0;
        long savedDate = fromDate.getTimeInMillis();
        while (future && !fromDate.after(toDate) || !future && !fromDate.before(toDate)) {
            savedDate = fromDate.getTimeInMillis();
            fromDate.add(type, future ? 1 : -1);
            ++diff;
        }
        fromDate.setTimeInMillis(savedDate);
        return --diff;
    }

    public static String formatDateDiff(long date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(date);
        GregorianCalendar now = new GregorianCalendar();
        return DateUtils.formatDateDiff(now, c);
    }

    public static String formatDateDiff(Calendar fromDate, Calendar toDate) {
        boolean future = false;
        if (toDate.equals(fromDate)) {
            return "now";
        }
        if (toDate.after(fromDate)) {
            future = true;
        }
        StringBuilder sb = new StringBuilder();
        int[] types = new int[]{1, 2, 5, 11, 12, 13};
        String[] names = new String[]{"ans", "an", "mois", "mois", "jours", "jour", "heures", "heure", "minutes", "minute", "secondes", "seconde"};
        int accuracy = 0;
        for (int i = 0; i < types.length && accuracy <= 2; ++i) {
            int diff = DateUtils.dateDiff(types[i], fromDate, toDate, future);
            if (diff <= 0) continue;
            ++accuracy;
            sb.append(" ").append(diff).append(" ").append(names[i * 2 + 0]);
        }
        return sb.length() == 0 ? "now" : sb.toString().trim();
    }

    public static String formatDateDiff(Date fromDate, Date toDate) {
        boolean future = false;
        Calendar fromCalendar = Calendar.getInstance();
        fromCalendar.setTime(fromDate);
        Calendar toCalendar = Calendar.getInstance();
        toCalendar.setTime(toDate);
        if (toDate.equals(fromDate)) {
            return "now";
        }
        if (toDate.after(fromDate)) {
            future = true;
        }
        StringBuilder sb = new StringBuilder();
        int[] types = new int[]{1, 2, 5, 11, 12, 13};
        String[] names = new String[]{"ans", "an", "mois", "mois", "jours", "jour", "heures", "heure", "minutes", "minute", "secondes", "seconde"};
        int accuracy = 0;
        for (int i = 0; i < types.length && accuracy <= 2; ++i) {
            int diff = DateUtils.dateDiff(types[i], fromCalendar, toCalendar, future);
            if (diff <= 0) continue;
            ++accuracy;
            sb.append(" ").append(diff).append(" ").append(names[i * 2 + 0]);
        }
        return sb.length() == 0 ? "now" : sb.toString().trim();
    }

    public static String dateWithMillis(long specified) {
        Date now = new Date();
        long date = now.getTime() + specified;
        now.setTime(date);
        return new SimpleDateFormat("dd/MM/yy '|' HH'h'mm").format(date);
    }

    public static String DB_dateWithMillis(long specified) {
        Date now = new Date();
        long date = now.getTime() + specified;
        now.setTime(date);
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(date);
    }

    public static String DB_dateWithMillisInFuture(long specified) {
        Date now = new Date();
        long date = now.getTime() - specified;
        now.setTime(date);
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(date);
    }

    public static String DateEnded(String specified) {
        try {
            return new SimpleDateFormat("dd/MM/yy '|' HH'h'mm").format(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").parse(specified));
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static Date StringToDate(String specified) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").parse(specified);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Date();
        }
    }

    public static String timeToLeft(long specified) {
        Date now = new Date();
        long left = now.getTime() - specified;
        return DateUtils.formatDateDiff(left);
    }

    public static String timeBetweenTwoDateString(String specified, String originalDate) {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(DateUtils.StringToDate(specified));
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(DateUtils.StringToDate(originalDate));
        return DateUtils.formatDateDiff(calendar1, calendar2);
    }
}

