/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.scoreboard;

import eu.scorpionltd.scoreboard.Sidebar;
import eu.scorpionltd.scoreboard.Sideline;
import eu.scorpionltd.utils.player.ScorpionPlayer;
import java.util.HashMap;
import java.util.Map;

public abstract class SidebarManager {
    HashMap<ScorpionPlayer, Sidebar> sidebars = new HashMap();
    HashMap<ScorpionPlayer, Sideline> sidelines = new HashMap();
    private TimeProvider timeProvider = null;

    public synchronized void update() {
        for (Map.Entry<ScorpionPlayer, Sidebar> e : new HashMap<ScorpionPlayer, Sidebar>(this.sidebars).entrySet()) {
            ScorpionPlayer p = e.getKey();
            Sidebar sb = e.getValue();
            Sideline sl = this.sidelines.get(e.getKey());
            SidebarEditor editor = new SidebarEditor(sb, sl, "DefaultTitle");
            this.build(p, editor);
            editor.send();
        }
    }

    @Deprecated
    public void gameSec(Integer time) {
        this.update();
    }

    @Deprecated
    public void gameUpdate() {
        this.update();
    }

    @Deprecated
    public void ingame(Sidebar sb, Sideline sl, ScorpionPlayer p) {
    }

    @Deprecated
    public void finished(Sidebar sb, Sideline sl, ScorpionPlayer p) {
    }

    public void build(ScorpionPlayer p, SidebarEditor e) {
    }

    public void join(ScorpionPlayer p) {
        Sidebar sb = new Sidebar(p);
        this.sidebars.put(p, sb);
        this.sidelines.put(p, new Sideline(sb));
    }

    public void leave(ScorpionPlayer p) {
        Sidebar sb = this.sidebars.remove(p);
        if (sb != null) {
            sb.remove();
        }
        this.sidelines.remove(p);
    }

    public void setTimeProvider(TimeProvider timeProvider) {
        this.timeProvider = timeProvider;
    }

    public class SidebarEditor {
        Sidebar sb;
        Sideline sl;
        String title;
        Boolean flush = false;

        SidebarEditor(Sidebar sb, Sideline sl, String defaultTitle) {
            this.sb = sb;
            this.sl = sl;
            this.title = defaultTitle;
        }

        public void add(String str) {
            this.sl.add(str);
            this.flush = true;
        }

        public void setAt(Integer i, String str) {
            this.sl.set(i, str);
        }

        public void setByScore(String str, Integer score) {
            this.sb.setLine(str, score);
        }

        public void clear() {
            this.sl.clear();
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public Integer getRemainingSize() {
            return this.sl.getRemainingSize();
        }

        void send() {
            if (this.flush.booleanValue()) {
                this.sl.flush();
            } else {
                this.sb.send();
            }
            this.sb.setName(this.title);
        }
    }

    public static interface TimeProvider {
        public Integer getTime();
    }
}

