/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.scoreboard;

import eu.scorpionltd.utils.player.ScorpionPlayer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.server.v1_8_R3.IScoreboardCriteria;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketPlayOutScoreboardDisplayObjective;
import net.minecraft.server.v1_8_R3.PacketPlayOutScoreboardObjective;
import net.minecraft.server.v1_8_R3.PacketPlayOutScoreboardScore;
import net.minecraft.server.v1_8_R3.PlayerConnection;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;

public class Sidebar {
    private ScorpionPlayer player;
    private HashMap<String, Integer> linesA;
    private HashMap<String, Integer> linesB;
    private String name = "";
    private String bufferUnique = String.valueOf(new Random().nextLong() % 1000000000L);
    private Boolean a = true;

    private String getBuffer() {
        return this.a != false ? this.bufferUnique + "A" : this.bufferUnique + "B";
    }

    private HashMap<String, Integer> linesBuffer() {
        return this.a != false ? this.linesA : this.linesB;
    }

    private HashMap<String, Integer> linesDisplayed() {
        return this.a == false ? this.linesA : this.linesB;
    }

    private void swapBuffer() {
        this.a = this.a == false;
    }

    public Sidebar(ScorpionPlayer p) {
        this.player = p;
        this.linesA = new HashMap();
        this.linesB = new HashMap();
        PacketPlayOutScoreboardObjective packetA = new PacketPlayOutScoreboardObjective();
        this.setField(packetA, "a", this.bufferUnique + "A");
        this.setField(packetA, "b", "");
        this.setField(packetA, "d", 0);
        this.setField(packetA, "c", IScoreboardCriteria.EnumScoreboardHealthDisplay.INTEGER);
        PacketPlayOutScoreboardObjective packetB = new PacketPlayOutScoreboardObjective();
        this.setField(packetB, "a", this.bufferUnique + "B");
        this.setField(packetB, "b", "");
        this.setField(packetB, "d", 0);
        this.setField(packetB, "c", IScoreboardCriteria.EnumScoreboardHealthDisplay.INTEGER);
        this.getPlayer().sendPacket((Packet)packetA);
        this.getPlayer().sendPacket((Packet)packetB);
    }

    public synchronized void send() {
        PacketPlayOutScoreboardDisplayObjective packet = new PacketPlayOutScoreboardDisplayObjective();
        this.setField(packet, "a", 1);
        this.setField(packet, "b", this.getBuffer());
        this.swapBuffer();
        this.getPlayer().sendPacket((Packet)packet);
        for (String text : this.linesDisplayed().keySet()) {
            if (this.linesBuffer().containsKey(text) && this.linesBuffer().get(text) == this.linesDisplayed().get(text)) continue;
            this.setLine(text, this.linesDisplayed().get(text));
        }
        for (String text : new ArrayList<String>(this.linesBuffer().keySet())) {
            if (this.linesDisplayed().containsKey(text)) continue;
            this.removeLine(text);
        }
    }

    public synchronized void remove() {
        PacketPlayOutScoreboardObjective packetA = new PacketPlayOutScoreboardObjective();
        this.setField(packetA, "a", this.bufferUnique + "A");
        this.setField(packetA, "b", "");
        this.setField(packetA, "d", 1);
        PacketPlayOutScoreboardObjective packetB = new PacketPlayOutScoreboardObjective();
        this.setField(packetB, "a", this.bufferUnique + "B");
        this.setField(packetB, "b", "");
        this.setField(packetB, "d", 1);
        this.getPlayer().sendPacket((Packet)packetA);
        this.getPlayer().sendPacket((Packet)packetB);
    }

    public synchronized void clear() {
        for (String text : new ArrayList<String>(this.linesBuffer().keySet())) {
            this.removeLine(text);
        }
    }

    public synchronized void setLine(String text, Integer line) {
        if (text == null) {
            return;
        }
        if (text.length() > 40) {
            text = text.substring(0, 40);
        }
        if (this.linesBuffer().containsKey(text)) {
            this.removeLine(text);
        }
        PacketPlayOutScoreboardScore packet = new PacketPlayOutScoreboardScore(text);
        this.setField(packet, "b", this.getBuffer());
        this.setField(packet, "c", line);
        this.setField(packet, "d", PacketPlayOutScoreboardScore.EnumScoreboardAction.CHANGE);
        this.getPlayer().sendPacket((Packet)packet);
        this.linesBuffer().put(text, line);
    }

    public synchronized void removeLine(String text) {
        if (text.length() > 40) {
            text = text.substring(0, 40);
        }
        if (!this.linesBuffer().containsKey(text)) {
            return;
        }
        Integer line = this.linesBuffer().get(text);
        PacketPlayOutScoreboardScore packet = new PacketPlayOutScoreboardScore(text);
        this.setField(packet, "b", this.getBuffer());
        this.setField(packet, "c", line);
        this.setField(packet, "d", PacketPlayOutScoreboardScore.EnumScoreboardAction.REMOVE);
        PlayerConnection playerConnection = this.getPlayer();
        if (playerConnection != null) {
            playerConnection.sendPacket((Packet)packet);
        }
        this.linesBuffer().remove(text);
    }

    public void setName(String displayName) {
        if (displayName.length() > 32) {
            displayName = displayName.substring(0, 32);
        }
        if (displayName.equals(this.name)) {
            return;
        }
        this.name = displayName;
        PacketPlayOutScoreboardObjective packetA = new PacketPlayOutScoreboardObjective();
        this.setField(packetA, "a", this.bufferUnique + "A");
        this.setField(packetA, "b", displayName);
        this.setField(packetA, "d", 2);
        this.setField(packetA, "c", IScoreboardCriteria.EnumScoreboardHealthDisplay.INTEGER);
        PacketPlayOutScoreboardObjective packetB = new PacketPlayOutScoreboardObjective();
        this.setField(packetB, "a", this.bufferUnique + "B");
        this.setField(packetB, "b", displayName);
        this.setField(packetB, "d", 2);
        this.setField(packetB, "c", IScoreboardCriteria.EnumScoreboardHealthDisplay.INTEGER);
        this.getPlayer().sendPacket((Packet)packetA);
        this.getPlayer().sendPacket((Packet)packetB);
    }

    private void setField(Object edit, String fieldName, Object value) {
        try {
            Field field = edit.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(edit, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    private PlayerConnection getPlayer() {
        return ((CraftPlayer)this.player.getPlayer()).getHandle().playerConnection;
    }
}

