/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.licence;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import org.bukkit.Bukkit;

public class Web {
    private static final String BASE_URL = "https://pluginapi.scorpionltd.eu/";
    private static final String BASE_URL_PLUGINS = "https://pluginapi.scorpionltd.eu/scorpion/plugins/";
    private static final String LICENCE_VALIDATE_ENDPOINT = "scorpion/licence/validate";
    private static final String UPDATE_CHECK_ENDPOINT = "scorpion/update/check";
    private static final String TOKEN_GENERATE_ENDPOINT = "scorpion/token/generate";
    private static final String DOWNLOAD_ENDPOINT = "scorpion/download";
    private static final String NOACCESS_ENDPOINT = "scorpion/licence/noaccess";
    private static final String API_KEY = "ScorpionLTD_NLbcQ3W2duHEha2OTiGJ57fWbpEpRbqPIcqIVY6IGnYSVV58cvWyBgGXa1p0TONw";

    private static JsonObject requestJson(String fullUrl, boolean usePost, String bodyJson) {
        try {
            String line;
            InputStream is;
            URL url = new URL(fullUrl);
            HttpURLConnection http = (HttpURLConnection)url.openConnection();
            http.setRequestMethod(usePost ? "POST" : "GET");
            http.setRequestProperty("User-Agent", "ScorpionLTD-API");
            http.setRequestProperty("X-Scorpion-Api-Key", API_KEY);
            http.setRequestProperty("Accept", "application/json");
            http.setConnectTimeout(5000);
            http.setReadTimeout(5000);
            if (usePost) {
                http.setDoOutput(true);
                http.setRequestProperty("Content-Type", "application/json");
                OutputStream os = http.getOutputStream();
                os.write(bodyJson.getBytes("UTF-8"));
                os.flush();
                os.close();
            }
            InputStream inputStream = is = http.getResponseCode() < 300 ? http.getInputStream() : http.getErrorStream();
            if (is == null) {
                Bukkit.getLogger().severe("[Web] Null InputStream for URL: " + fullUrl);
                return null;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            br.close();
            JsonReader reader = new JsonReader((Reader)new StringReader(sb.toString()));
            reader.setLenient(true);
            return new JsonParser().parse(reader).getAsJsonObject();
        }
        catch (Exception e) {
            Bukkit.getLogger().severe("[Web] Error on request : " + fullUrl + " | " + e.getMessage());
            return null;
        }
    }

    public static JsonObject validateLicence(String licence, String mac, String productId) {
        String url = "https://pluginapi.scorpionltd.eu/scorpion/licence/validate?licence=" + Web.encode(licence) + "&mac=" + Web.encode(mac) + "&productId=" + Web.encode(productId);
        return Web.requestJson(url, false, null);
    }

    public static JsonObject checkUpdate(String productId, String currentVersion) {
        String url = "https://pluginapi.scorpionltd.eu/scorpion/update/check?productId=" + Web.encode(productId) + "&currentVersion=" + Web.encode(currentVersion);
        return Web.requestJson(url, false, null);
    }

    public static JsonObject generateDownloadToken(String productId, String licence, String mac) {
        String url = "https://pluginapi.scorpionltd.eu/scorpion/token/generate?productId=" + Web.encode(productId) + "&licence=" + Web.encode(licence) + "&mac=" + Web.encode(mac);
        return Web.requestJson(url, false, null);
    }

    public static boolean downloadPlugin(String token, File destination) {
        String url = "https://pluginapi.scorpionltd.eu/scorpion/download?token=" + Web.encode(token);
        try {
            URL u = new URL(url);
            URLConnection conn = u.openConnection();
            conn.setRequestProperty("User-Agent", "ScorpionLTD-API");
            conn.setRequestProperty("X-Scorpion-Api-Key", API_KEY);
            try (InputStream in = conn.getInputStream();
                 FileOutputStream out = new FileOutputStream(destination);){
                int len;
                byte[] buffer = new byte[8192];
                while ((len = in.read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                }
            }
            return true;
        }
        catch (Exception e) {
            Bukkit.getLogger().severe("[Web] Download error: " + e.getMessage());
            return false;
        }
    }

    public static void postNoAccess(String licence, String mac, String productId, String pluginName) {
        JsonObject body = new JsonObject();
        body.addProperty("licence", licence);
        body.addProperty("mac", mac);
        body.addProperty("productId", productId);
        body.addProperty("pluginName", pluginName);
        Web.requestJson("https://pluginapi.scorpionltd.eu/scorpion/licence/noaccess", true, body.toString());
    }

    public static JsonObject getMetadata(String pluginName) {
        String url = BASE_URL_PLUGINS + pluginName + "/metadata";
        return Web.simpleGET(url);
    }

    public static boolean downloadPluginFile(String pluginName, String fileName, File dest) {
        String url = BASE_URL_PLUGINS + pluginName + "/download/" + fileName;
        return Web.downloadRawFile(url, dest);
    }

    public static JsonObject simpleGET(String urlStr) {
        try {
            int len;
            URL url = new URL(urlStr);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("User-Agent", "ScorpionLTD-API");
            con.setRequestProperty("X-Scorpion-Api-Key", API_KEY);
            con.setConnectTimeout(5000);
            con.setReadTimeout(5000);
            InputStream in = con.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((len = in.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            String json = new String(baos.toByteArray(), "UTF-8");
            return new JsonParser().parse(json).getAsJsonObject();
        }
        catch (Exception e) {
            Bukkit.getLogger().severe("[Web] Error GET : " + urlStr);
            e.printStackTrace();
            return null;
        }
    }

    public static boolean downloadRawFile(String urlStr, File dest) {
        try {
            int len;
            URL url = new URL(urlStr);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestProperty("User-Agent", "ScorpionLTD-API");
            con.setRequestProperty("X-Scorpion-Api-Key", API_KEY);
            InputStream in = con.getInputStream();
            FileOutputStream out = new FileOutputStream(dest);
            byte[] buffer = new byte[4096];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
            out.close();
            in.close();
            return true;
        }
        catch (Exception e) {
            Bukkit.getLogger().severe("[Web] Error DOWNLOAD : " + urlStr);
            e.printStackTrace();
            return false;
        }
    }

    private static String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (Exception e) {
            return s;
        }
    }
}

