/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.licence;

import com.google.gson.JsonObject;
import eu.scorpionltd.API;
import eu.scorpionltd.licence.Web;
import java.io.File;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class LicenceManager {
    private final String licenceKey;
    private final String macAddress;
    private boolean admin;
    private boolean whitelistedIP;
    private boolean valid;
    private final List<String> allowedProducts = new ArrayList<String>();
    private final Map<String, List<String>> modules = new HashMap<String, List<String>>();
    private final Map<Plugin, Long> loadedPlugins = new HashMap<Plugin, Long>();
    private final Map<Plugin, String> pluginProductIds = new HashMap<Plugin, String>();

    public LicenceManager(String licenceKey) {
        this.licenceKey = licenceKey;
        this.macAddress = LicenceManager.retrieveMac();
    }

    public void loadPlugin(Plugin plugin) {
        try {
            File file = new File(plugin.getClass().getProtectionDomain().getCodeSource().getLocation().getFile());
            this.loadedPlugins.put(plugin, file.length());
        }
        catch (Exception e) {
            plugin.getLogger().log(Level.SEVERE, "Licence \uffed Vous ne pouvez utiliser le plugin : " + plugin.getName() + ". S'il s'agit d'une erreur, contactez un membre du staff ScorpionLTD.");
        }
    }

    public void registerPlugin(Plugin plugin, String productId) {
        this.pluginProductIds.put(plugin, productId);
    }

    public boolean setupForPlugin(Plugin plugin) {
        String productId = this.pluginProductIds.get(plugin);
        if (plugin.getName().equalsIgnoreCase("ScorpionLTD-API")) {
            if (productId == null) {
                Bukkit.getLogger().log(Level.SEVERE, "Licence \uffed Afin de d\u00e9marrer ce serveur, vous devez sp\u00e9cifier un productId valide dans le fichier : /plugins/ScorpionLTD-API/config.yml");
                Bukkit.shutdown();
                return false;
            }
            JsonObject json = Web.validateLicence(this.licenceKey, this.macAddress, productId);
            if (json == null) {
                Bukkit.getLogger().severe("Licence \uffed Impossible de contacter l'API.");
                Bukkit.shutdown();
                return false;
            }
            boolean licenceValid = json.get("licenceValid").getAsBoolean();
            boolean whitelisted = json.get("whitelistedIP").getAsBoolean();
            if (!licenceValid) {
                Bukkit.getLogger().log(Level.SEVERE, "Licence \uffed Afin de d\u00e9marrer ce serveur, vous devez sp\u00e9cifier une licence valide dans le fichier : /plugins/ScorpionLTD-API/config.yml");
                Bukkit.shutdown();
                return false;
            }
            if (!whitelisted) {
                Bukkit.getLogger().log(Level.SEVERE, "Licence \uffed L'adresse IP n'est pas autoris\u00e9e \u00e0 utiliser cette licence.");
                Bukkit.shutdown();
                return false;
            }
            return true;
        }
        return true;
    }

    public void updatePlugins() {
        boolean restartNeeded = false;
        for (Plugin plugin : this.loadedPlugins.keySet()) {
            String pluginName = plugin.getName();
            if (pluginName.equalsIgnoreCase("ScorpionLTD-API")) {
                File currentJar;
                File dest;
                JsonObject tokenJson;
                String currentVersion;
                String productId = this.pluginProductIds.get(plugin);
                JsonObject json = Web.checkUpdate(productId, currentVersion = plugin.getDescription().getVersion());
                if (json == null || !json.get("updateAvailable").getAsBoolean() || (tokenJson = Web.generateDownloadToken(productId, this.licenceKey, this.macAddress)) == null || !tokenJson.has("token")) continue;
                String token = tokenJson.get("token").getAsString();
                if (Web.downloadPlugin(token, dest = new File("plugins", (currentJar = new File(plugin.getClass().getProtectionDomain().getCodeSource().getLocation().getFile())).getName()))) {
                    API.getInstance().sendConsole("> ScorpionLTD-API mis \u00e0 jour.");
                    restartNeeded = true;
                    continue;
                }
                Bukkit.getLogger().log(Level.SEVERE, "ScorpionLTD \uffed Erreur t\u00e9l\u00e9chargement API.");
                continue;
            }
            JsonObject meta = Web.getMetadata(pluginName);
            if (meta == null) continue;
            String latest = meta.get("version").getAsString();
            String fileName = meta.get("fileName").getAsString();
            String current = plugin.getDescription().getVersion();
            if (current.equals(latest)) continue;
            File currentJar = new File(plugin.getClass().getProtectionDomain().getCodeSource().getLocation().getFile());
            if (Web.downloadPluginFile(pluginName, fileName, currentJar)) {
                API.getInstance().sendConsole("> " + pluginName + " mis \u00e0 jour.");
                restartNeeded = true;
                continue;
            }
            Bukkit.getLogger().log(Level.SEVERE, "Erreur lors du t\u00e9l\u00e9chargement de " + pluginName);
        }
        if (restartNeeded) {
            Bukkit.getLogger().log(Level.SEVERE, "Licence \uffed Le serveur doit \u00eatre red\u00e9marr\u00e9 afin de mettre \u00e0 jour le ou les plugins.");
            Bukkit.shutdown();
        }
    }

    public boolean isProductAllowed(String productId) {
        return this.admin || this.allowedProducts.contains(productId);
    }

    public boolean isModuleAllowed(String type, String moduleName) {
        if (this.admin) {
            return true;
        }
        return this.modules.getOrDefault(type, Collections.emptyList()).contains(moduleName);
    }

    private void blankConsole() {
        for (int i = 0; i < 8; ++i) {
            Bukkit.getLogger().log(Level.SEVERE, " ");
        }
    }

    private void shutdown() {
        Bukkit.getScheduler().runTask(Bukkit.getPluginManager().getPlugin("ScorpionLTD-API"), Bukkit::shutdown);
    }

    private static String retrieveMac() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                byte[] mac;
                NetworkInterface ni = interfaces.nextElement();
                if (ni.isLoopback() || ni.isVirtual() || !ni.isUp() || (mac = ni.getHardwareAddress()) == null) continue;
                StringBuilder sb = new StringBuilder();
                for (byte b : mac) {
                    sb.append(String.format("%02X", b));
                }
                return sb.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "UNKNOWN-MAC";
    }
}

