/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.licence;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.NetworkInterface;
import java.net.URL;
import java.security.MessageDigest;
import java.util.Enumeration;

public class LicenceAPI {
    private static final String API_URL_SUFFIX = "/api/v1/validate";
    private String ip;
    private String url;
    private String licenseKey;
    private int productId;
    private String productVersion;
    private String hwid;
    private String macAddress;
    private String operatingSystem;
    private String operatingSystemVersion;
    private String operatingSystemArchitecture;
    private String javaVersion;

    public LicenceAPI(String licenseKey, int productId, String productVersion, String url) {
        this.licenseKey = licenseKey;
        this.productId = productId;
        this.productVersion = productVersion;
        this.url = url;
        this.hwid = LicenceAPI.getHWID();
        this.macAddress = LicenceAPI.getMacAddress();
        this.operatingSystem = System.getProperty("os.name");
        this.operatingSystemVersion = System.getProperty("os.version");
        this.operatingSystemArchitecture = System.getProperty("os.arch");
        this.javaVersion = System.getProperty("java.version");
    }

    public static LicenceAPI getLicenseFromFile(String filePath, int productId, String productVersion, String LicenseServerUrl) throws IOException {
        if (filePath == null || filePath.isEmpty()) {
            throw new IllegalArgumentException("File path is missing.");
        }
        if (LicenseServerUrl == null || LicenseServerUrl.isEmpty()) {
            throw new IllegalArgumentException("License server URL is missing.");
        }
        try (BufferedReader br = new BufferedReader(new FileReader(filePath));){
            String licenseKey = br.readLine();
            if (licenseKey != null) {
                LicenceAPI licenceAPI = new LicenceAPI(licenseKey, productId, productVersion, LicenseServerUrl);
                return licenceAPI;
            }
            throw new IllegalArgumentException("License key is missing in the file.");
        }
    }

    public static LicenceAPI getLicence(String licenseKey, int productId, String productVersion, String LicenseServerUrl) {
        if (LicenseServerUrl == null || LicenseServerUrl.isEmpty()) {
            throw new IllegalArgumentException("License server URL is missing.");
        }
        if (LicenseServerUrl != null && LicenseServerUrl.endsWith("/")) {
            LicenseServerUrl = LicenseServerUrl.substring(0, LicenseServerUrl.length() - 1);
        }
        return new LicenceAPI(licenseKey, productId, productVersion, LicenseServerUrl);
    }

    public void validate() throws IOException {
        if (this.licenseKey == null || this.licenseKey.isEmpty()) {
            throw new IllegalArgumentException("License key is missing.");
        }
        String jsonInputString = String.format("{\"licenseKey\": \"%s\", \"productId\": %d, \"productVersion\": \"%s\", \"hwid\": \"%s\", \"macAddress\": \"%s\", \"operatingSystem\": \"%s\", \"operatingSystemVersion\": \"%s\", \"operatingSystemArchitecture\": \"%s\", \"javaVersion\": \"%s\"%s}", this.licenseKey, this.productId, this.productVersion, this.hwid, this.macAddress, this.operatingSystem, this.operatingSystemVersion, this.operatingSystemArchitecture, this.javaVersion, this.ip != null && !this.ip.isEmpty() ? String.format(", \"ip\": \"%s\"", this.ip) : "");
        URL url = new URL(this.url + API_URL_SUFFIX);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json; utf-8");
        conn.setRequestProperty("Accept", "application/json");
        conn.setDoOutput(true);
        try (OutputStream os = conn.getOutputStream();){
            byte[] input = jsonInputString.getBytes("utf-8");
            os.write(input, 0, input.length);
        }
        int responseCode = conn.getResponseCode();
        if (responseCode != 200) {
            throw new RuntimeException("Invalid license. Response Code: " + responseCode + " : " + conn.getResponseMessage());
        }
    }

    public static String getHWID() {
        try {
            byte[] byteData;
            String toEncrypt = System.getenv("COMPUTERNAME") + System.getProperty("user.name") + System.getenv("PROCESSOR_IDENTIFIER") + System.getenv("PROCESSOR_LEVEL");
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(toEncrypt.getBytes());
            StringBuffer hexString = new StringBuffer();
            for (byte aByteData : byteData = md.digest()) {
                String hex = Integer.toHexString(0xFF & aByteData);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "Error";
        }
    }

    private static String getMacAddress() {
        try {
            Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
            while (networks.hasMoreElements()) {
                NetworkInterface network = networks.nextElement();
                byte[] macArray = network.getHardwareAddress();
                if (macArray == null) continue;
                StringBuilder mac = new StringBuilder();
                for (byte b : macArray) {
                    mac.append(String.format("%02X:", b));
                }
                if (mac.length() > 0) {
                    mac.deleteCharAt(mac.length() - 1);
                }
                return mac.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "00:1A:2B:3C:4D:5E";
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getLicenceKey() {
        return this.licenseKey;
    }

    public void setLicenceKey(String licenseKey) {
        this.licenseKey = licenseKey;
    }

    public int getProductId() {
        return this.productId;
    }

    public void setProductId(int productId) {
        this.productId = productId;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public String getHwid() {
        return this.hwid;
    }

    public void setHwid(String hwid) {
        this.hwid = hwid;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public void setOperatingSystem(String operatingSystem) {
        this.operatingSystem = operatingSystem;
    }

    public String getOperatingSystemVersion() {
        return this.operatingSystemVersion;
    }

    public void setOperatingSystemVersion(String operatingSystemVersion) {
        this.operatingSystemVersion = operatingSystemVersion;
    }

    public String getOperatingSystemArchitecture() {
        return this.operatingSystemArchitecture;
    }

    public void setOperatingSystemArchitecture(String operatingSystemArchitecture) {
        this.operatingSystemArchitecture = operatingSystemArchitecture;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }
}

