/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.database.pubsub;

import java.util.HashMap;
import java.util.HashSet;
import redis.clients.jedis.JedisPubSub;

public class Subscriber
extends JedisPubSub {
    protected HashMap<String, HashSet<PacketsReceiver>> packetsReceivers = new HashMap();
    protected HashMap<String, HashSet<PatternReceiver>> patternsReceivers = new HashMap();

    public void registerReceiver(String channel, PacketsReceiver receiver) {
        HashSet<PacketsReceiver> receivers = this.packetsReceivers.get(channel);
        if (receivers == null) {
            receivers = new HashSet();
        }
        receivers.add(receiver);
        this.subscribe(channel);
        this.packetsReceivers.put(channel, receivers);
    }

    public void registerPattern(String pattern, PatternReceiver receiver) {
        HashSet<PatternReceiver> receivers = this.patternsReceivers.get(pattern);
        if (receivers == null) {
            receivers = new HashSet();
        }
        receivers.add(receiver);
        this.psubscribe(pattern);
        this.patternsReceivers.put(pattern, receivers);
    }

    @Override
    public void onMessage(String channel, String message) {
        try {
            HashSet<PacketsReceiver> receivers = this.packetsReceivers.get(channel);
            if (receivers != null) {
                receivers.forEach(receiver -> receiver.receive(channel, message));
            }
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
    }

    @Override
    public void onPMessage(String pattern, String channel, String message) {
        try {
            HashSet<PatternReceiver> receivers = this.patternsReceivers.get(pattern);
            if (receivers != null) {
                receivers.forEach(receiver -> receiver.receive(pattern, channel, message));
            }
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
    }

    public static interface PacketsReceiver {
        public void receive(String var1, String var2);
    }

    public static interface PatternReceiver {
        public void receive(String var1, String var2, String var3);
    }
}

