/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.database.pubsub;

import eu.scorpionltd.API;
import eu.scorpionltd.database.manager.RedisManager;
import eu.scorpionltd.database.pubsub.PendingMessage;
import eu.scorpionltd.database.pubsub.Sender;
import eu.scorpionltd.database.pubsub.Subscriber;
import redis.clients.jedis.JedisCluster;

public class PubSub {
    private Subscriber subscriber = new Subscriber();
    private Sender sender;
    private boolean continueSub = true;

    public PubSub() {
        new Thread(() -> {
            while (this.continueSub) {
                API.getInstance().getLogger().severe("heu test");
                JedisCluster jedis = RedisManager.getJedis("JEDIS: PubSub.java LOAD");
                try {
                    jedis.psubscribe(this.subscriber, "*");
                }
                catch (Exception e) {
                    jedis.close();
                    e.printStackTrace();
                }
            }
        }).start();
        while (!this.subscriber.isSubscribed()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.sender = new Sender();
        new Thread((Runnable)this.sender, "SenderThread").start();
    }

    public void subscribe(String channel, Subscriber.PacketsReceiver receiver) {
        this.subscriber.registerReceiver(channel, receiver);
    }

    public void subscribe(String pattern, Subscriber.PatternReceiver receiver) {
        this.subscriber.registerPattern(pattern, receiver);
    }

    public void send(String channel, String message) {
        this.sender.publish(new PendingMessage(channel, message));
    }

    public void send(PendingMessage message) {
        this.sender.publish(message);
    }

    public Sender getSender() {
        return this.sender;
    }

    public void disable() {
        this.continueSub = false;
        this.subscriber.unsubscribe();
        this.subscriber.punsubscribe();
        try {
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

