/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.database.manager;

import eu.scorpionltd.API;
import eu.scorpionltd.database.Data;
import eu.scorpionltd.database.pubsub.PubSub;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPoolConfig;

public class RedisManager {
    public static Map<UUID, Data> cache = new HashMap<UUID, Data>();
    private static JedisCluster jedis;
    public static PubSub pubsub;
    private static String password;
    private static Set<HostAndPort> sentinels;

    public static void load() {
        if (jedis != null) {
            RedisManager.disable();
        }
        FileConfiguration config = API.getInstance().getConfig();
        String host = config.getString("database.host");
        int port = config.getInt("database.port");
        List ports = config.getIntegerList("database.cluster");
        if (ports.isEmpty()) {
            sentinels.add(new HostAndPort(host, port));
            System.out.println("REDIS_CLUSTER: STANDALONE SANTINEL");
        } else {
            for (Integer p : ports) {
                sentinels.add(new HostAndPort(host, p));
            }
            System.out.println("REDIS_CLUSTER: CLUSTER MULTIPLE " + sentinels.size() + " nodes");
        }
        password = config.getString("database.password");
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(3000);
        poolConfig.setMaxWaitMillis(1000L);
        poolConfig.setMinIdle(15);
        poolConfig.setMaxIdle(25);
        poolConfig.setBlockWhenExhausted(false);
        jedis = new JedisCluster(sentinels, 2000, 2000, 2, password, (GenericObjectPoolConfig)poolConfig);
        RedisManager.startTask();
        System.out.println("REDIS-SQL: Chargement de la database RedisSQL.");
    }

    public static void disable() {
        jedis.close();
        jedis = null;
    }

    public static void startTask() {
        new BukkitRunnable(){

            public void run() {
                new HashMap<UUID, Data>(cache).forEach((uuid, data) -> {
                    if (Bukkit.getPlayer((UUID)uuid) == null) {
                        RedisManager.deleteCache(uuid);
                    }
                });
            }
        }.runTaskTimerAsynchronously((Plugin)API.getInstance(), 100L, 100L);
    }

    public static JedisCluster getJedis(String source) {
        System.out.println(source);
        if (jedis == null) {
            RedisManager.load();
        }
        return jedis;
    }

    public static PubSub getPubSub() {
        return pubsub;
    }

    public static void loadCache(UUID uuid) {
        Data data = new Data(uuid);
        RedisManager.deleteCache(uuid);
        RedisManager.addCache(uuid, data);
    }

    public static Data getData(UUID uuid) {
        if (!cache.containsKey(uuid)) {
            RedisManager.loadCache(uuid);
        }
        return cache.getOrDefault(uuid, null);
    }

    public static void deleteCache(UUID uuid) {
        if (cache.containsKey(uuid)) {
            cache.remove(uuid);
        }
    }

    private static void addCache(UUID uuid, Data data) {
        cache.put(uuid, data);
    }

    static {
        sentinels = new HashSet<HostAndPort>();
    }
}

