/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.database;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.scorpionltd.database.manager.RedisManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class Data {
    private Map<String, String> data = new HashMap<String, String>();
    private UUID uuid;

    public Data(UUID uuid) {
        this.data = RedisManager.getJedis("JEDIS: LOAD DATA hGetAll " + uuid).hgetAll("supplayer:" + uuid);
        this.uuid = uuid;
    }

    public String getUsername() {
        return this.data.getOrDefault("USERNAME", "null");
    }

    public String getLastIP() {
        return this.data.getOrDefault("LASTIP", "0.0.0.0");
    }

    public String getLang() {
        return this.data.getOrDefault("FLAGS", "FR");
    }

    public String getTwitter() {
        return this.data.getOrDefault("TWITTER", "Unknown");
    }

    public String getCustom(String key) {
        return this.data.getOrDefault(key, null);
    }

    public void setCustom(String key, String value) {
        this.data.put(key, value);
    }

    public void setJson(String key, JsonObject json) {
        this.data.put(key, json.toString());
    }

    public Boolean getBool(String key) {
        String value = this.data.getOrDefault(key, "0");
        if (value.equalsIgnoreCase("1")) {
            return true;
        }
        return false;
    }

    public void update() {
        RedisManager.getJedis("s").hmset("scorpionPlayer:" + this.uuid, this.data);
        RedisManager.getPubSub().send("sql-bungee", "update " + this.uuid);
    }

    public JsonObject getData(String key) {
        if (!this.data.containsKey(key)) {
            return null;
        }
        return new JsonParser().parse(this.data.get(key)).getAsJsonObject();
    }
}

