/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.annotations.updater;

import eu.scorpionltd.annotations.updater.Task;
import eu.scorpionltd.annotations.updater.UpdateType;
import eu.scorpionltd.annotations.updater.Updater;
import eu.scorpionltd.annotations.updater.UpdaterListener;
import java.lang.reflect.Method;
import java.util.HashSet;

public class UpdateRegister {
    public static void register(UpdaterListener listener) {
        Method[] methods;
        for (Method m : methods = listener.getClass().getDeclaredMethods()) {
            if (!m.isAnnotationPresent(Updater.class)) continue;
            Updater updater = m.getAnnotation(Updater.class);
            UpdateRegister.addToHashMapList(updater.type(), m);
            Task.listener.put(m, listener);
        }
    }

    public static void unregister(UpdaterListener listener) {
        Method[] methods;
        for (Method m : methods = listener.getClass().getDeclaredMethods()) {
            if (!m.isAnnotationPresent(Updater.class)) continue;
            Updater updater = m.getAnnotation(Updater.class);
            UpdateRegister.removeFromHashMapList(updater.type(), m);
            Task.listener.remove(m);
        }
    }

    private static void addToHashMapList(UpdateType type, Method m) {
        HashSet<Method> methods = new HashSet<Method>();
        if (Task.methods.get((Object)type) != null) {
            methods = Task.methods.get((Object)type);
        }
        methods.add(m);
        Task.methods.put(type, methods);
    }

    private static void removeFromHashMapList(UpdateType type, Method m) {
        HashSet<Method> methods = Task.methods.get((Object)type);
        methods.remove(m);
        Task.methods.put(type, methods);
    }
}

