/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd.annotations.commands;

import eu.scorpionltd.API;
import eu.scorpionltd.annotations.commands.BukkitCommand;
import eu.scorpionltd.annotations.commands.BukkitCompleter;
import eu.scorpionltd.annotations.commands.Command;
import eu.scorpionltd.annotations.commands.CommandArgs;
import eu.scorpionltd.annotations.commands.Completer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.Player;
import org.bukkit.help.GenericCommandHelpTopic;
import org.bukkit.help.HelpTopic;
import org.bukkit.help.HelpTopicComparator;
import org.bukkit.help.IndexHelpTopic;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.SimplePluginManager;

public class CommandFramework
implements CommandExecutor {
    private Map<String, Map.Entry<Method, Object>> commandMap = new HashMap<String, Map.Entry<Method, Object>>();
    private CommandMap map;
    private Plugin plugin;

    public CommandFramework(Plugin plugin) {
        this.plugin = plugin;
        if (plugin.getServer().getPluginManager() instanceof SimplePluginManager) {
            SimplePluginManager manager = (SimplePluginManager)plugin.getServer().getPluginManager();
            try {
                Field field = SimplePluginManager.class.getDeclaredField("commandMap");
                field.setAccessible(true);
                this.map = (CommandMap)field.get(manager);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean onCommand(CommandSender sender, org.bukkit.command.Command cmd, String label, String[] args) {
        return this.handleCommand(sender, cmd, label, args);
    }

    public boolean handleCommand(CommandSender sender, org.bukkit.command.Command cmd, String label, String[] args) {
        for (int i = args.length; i >= 0; --i) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(label.toLowerCase());
            for (int x = 0; x < i; ++x) {
                buffer.append("." + args[x].toLowerCase());
            }
            String cmdLabel = buffer.toString();
            if (!this.commandMap.containsKey(cmdLabel)) continue;
            Method method = this.commandMap.get(cmdLabel).getKey();
            Object methodObject = this.commandMap.get(cmdLabel).getValue();
            Command command = method.getAnnotation(Command.class);
            if (!command.permission().equals("") && !sender.hasPermission(command.permission())) {
                API.getInstance().sendConsole("DEBUG Permission: " + command.permission());
                sender.sendMessage(command.noPerm());
                return true;
            }
            if (command.inGameOnly() && !(sender instanceof Player)) {
                sender.sendMessage("This command is only performable in game");
                return true;
            }
            try {
                method.invoke(methodObject, new CommandArgs(sender, cmd, label, args, cmdLabel.split("\\.").length - 1));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return true;
        }
        this.defaultCommand(new CommandArgs(sender, cmd, label, args, 0));
        return true;
    }

    public void registerCommands(Object obj) {
        for (Method m : obj.getClass().getMethods()) {
            if (m.getAnnotation(Command.class) != null) {
                Command command = m.getAnnotation(Command.class);
                if (m.getParameterTypes().length > 1 || m.getParameterTypes()[0] != CommandArgs.class) {
                    System.out.println("Unable to register command " + m.getName() + ". Unexpected method arguments");
                    continue;
                }
                this.registerCommand(command, command.name(), m, obj);
                for (String alias : command.aliases()) {
                    this.registerCommand(command, alias, m, obj);
                }
                continue;
            }
            if (m.getAnnotation(Completer.class) == null) continue;
            Completer comp = m.getAnnotation(Completer.class);
            if (m.getParameterTypes().length > 1 || m.getParameterTypes().length == 0 || m.getParameterTypes()[0] != CommandArgs.class) {
                System.out.println("Unable to register tab completer " + m.getName() + ". Unexpected method arguments");
                continue;
            }
            if (m.getReturnType() != List.class) {
                System.out.println("Unable to register tab completer " + m.getName() + ". Unexpected return type");
                continue;
            }
            this.registerCompleter(comp.name(), m, obj);
            for (String alias : comp.aliases()) {
                this.registerCompleter(alias, m, obj);
            }
        }
    }

    public void registerHelp() {
        TreeSet<GenericCommandHelpTopic> help = new TreeSet<GenericCommandHelpTopic>((Comparator<GenericCommandHelpTopic>)HelpTopicComparator.helpTopicComparatorInstance());
        for (String s : this.commandMap.keySet()) {
            BukkitCommand cmd;
            if (s.contains(".") || (cmd = (BukkitCommand)this.map.getCommand(s)) == null) continue;
            GenericCommandHelpTopic genericCommandHelpTopic = new GenericCommandHelpTopic((org.bukkit.command.Command)cmd);
            help.add(genericCommandHelpTopic);
        }
        IndexHelpTopic topic = new IndexHelpTopic(this.plugin.getName(), "All commands for " + this.plugin.getName(), null, help, "Below is a list of all " + this.plugin.getName() + " commands:");
        Bukkit.getServer().getHelpMap().addTopic((HelpTopic)topic);
    }

    public void registerCommand(Command command, String label, Method m, Object obj) {
        this.commandMap.put(label.toLowerCase(), new AbstractMap.SimpleEntry<Method, Object>(m, obj));
        this.commandMap.put(this.plugin.getName() + ':' + label.toLowerCase(), new AbstractMap.SimpleEntry<Method, Object>(m, obj));
        String cmdLabel = label.split("\\.")[0].toLowerCase();
        if (this.map.getCommand(cmdLabel) == null) {
            BukkitCommand cmd = new BukkitCommand(cmdLabel, this, this.plugin);
            this.map.register(this.plugin.getName(), (org.bukkit.command.Command)cmd);
        }
        if (!command.description().equalsIgnoreCase("") && cmdLabel == label) {
            this.map.getCommand(cmdLabel).setDescription(command.description());
        }
        if (!command.usage().equalsIgnoreCase("") && cmdLabel == label) {
            this.map.getCommand(cmdLabel).setUsage(command.usage());
        }
    }

    public void registerCompleter(String label, Method m, Object obj) {
        BukkitCommand command;
        String cmdLabel = label.split("\\.")[0].toLowerCase();
        if (this.map.getCommand(cmdLabel) == null) {
            command = new BukkitCommand(cmdLabel, this, this.plugin);
            this.map.register(this.plugin.getName(), (org.bukkit.command.Command)command);
        }
        if (this.map.getCommand(cmdLabel) instanceof BukkitCommand) {
            command = (BukkitCommand)this.map.getCommand(cmdLabel);
            if (command.completer == null) {
                command.completer = new BukkitCompleter();
            }
            command.completer.addCompleter(label, m, obj);
        } else if (this.map.getCommand(cmdLabel) instanceof PluginCommand) {
            try {
                command = this.map.getCommand(cmdLabel);
                Field field = ((Object)((Object)command)).getClass().getDeclaredField("completer");
                field.setAccessible(true);
                if (field.get((Object)command) == null) {
                    BukkitCompleter completer = new BukkitCompleter();
                    completer.addCompleter(label, m, obj);
                    field.set((Object)command, completer);
                } else if (field.get((Object)command) instanceof BukkitCompleter) {
                    BukkitCompleter completer = (BukkitCompleter)field.get((Object)command);
                    completer.addCompleter(label, m, obj);
                } else {
                    System.out.println("Unable to register tab completer " + m.getName() + ". A tab completer is already registered for that command!");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void unregisterCommand(String name) {
        org.bukkit.command.Command cmd = this.map.getCommand(name);
        if (cmd == null) {
            return;
        }
        cmd.unregister(this.map);
        for (String alias : cmd.getAliases()) {
            this.unregisterCommand(alias);
        }
    }

    private void defaultCommand(CommandArgs args) {
        args.getSender().sendMessage(args.getLabel() + " is not handled! Oh noes!");
    }
}

