/*
 * Decompiled with CFR 0.152.
 */
package eu.scorpionltd;

import eu.scorpionltd.annotations.UpdateManager;
import eu.scorpionltd.commands.CommandsManager;
import eu.scorpionltd.database.LoginQuitEvent;
import eu.scorpionltd.database.manager.DataPub;
import eu.scorpionltd.database.manager.RedisManager;
import eu.scorpionltd.database.pubsub.PubSub;
import eu.scorpionltd.licence.LicenceManager;
import eu.scorpionltd.listeners.EventManager;
import eu.scorpionltd.utils.task.Countdown;
import eu.scorpionltd.utils.variable.Variable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class API
extends JavaPlugin {
    private static API instance;
    public static LicenceManager licenceManager;
    private List<Variable> variable = new ArrayList<Variable>();
    private List<Countdown> countdowns = new ArrayList<Countdown>();
    private UpdateManager updatemanager = new UpdateManager(this);

    public void onLoad() {
        instance = this;
        String licence = this.getConfig().getString("licence.key");
        if (licence != null && !licence.isEmpty()) {
            licenceManager = new LicenceManager(licence);
        }
        this.saveDefaultConfig();
    }

    public void onEnable() {
        this.sendConsole("Loading API");
        EventManager.register((Plugin)this);
        CommandsManager.register((Plugin)this);
        this.updatemanager.register();
        String licence = this.getConfig().getString("licence.key");
        String productId = this.getConfig().getString("licence.productId");
        if (licence == null || licence.isEmpty()) {
            Bukkit.getLogger().log(Level.SEVERE, "Licence \uffed Aucune licence sp\u00e9cifi\u00e9. Vous devez sp\u00e9cifier une licence valide dans le fichier : /plugins/ScorpionLTD-API/config.yml");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (productId == null || productId.isEmpty()) {
            Bukkit.getLogger().log(Level.SEVERE, "Licence \uffed Aucun ID de produit sp\u00e9cifi\u00e9. Vous devez sp\u00e9cifier un productId valide dans le fichier : /plugins/ScorpionLTD-API/config.yml");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        licenceManager.loadPlugin((Plugin)this);
        licenceManager.registerPlugin((Plugin)this, productId);
        boolean ok = licenceManager.setupForPlugin((Plugin)this);
        if (!ok) {
            return;
        }
        licenceManager.updatePlugins();
        if (this.getConfig().getBoolean("database.enabled")) {
            RedisManager.load();
            RedisManager.pubsub = new PubSub();
            RedisManager.pubsub.subscribe("sql-spigot", new DataPub());
            EventManager.registerEvent(new LoginQuitEvent(), (Plugin)API.getInstance());
        }
    }

    public void onDisable() {
        if (this.getConfig().getBoolean("database.enabled")) {
            RedisManager.disable();
        }
    }

    public static API getInstance() {
        return instance;
    }

    public static String getPrefix() {
        return "ScorpionLTD \uffed ";
    }

    public static LicenceManager getLicenceManager() {
        return licenceManager;
    }

    public UpdateManager getUpdatemanager() {
        return this.updatemanager;
    }

    public void sendConsole(String string) {
        Bukkit.getConsoleSender().sendMessage("[H] " + string);
    }

    public List<Variable> getVariable() {
        return this.variable;
    }

    public Variable getVariableFromKey(String key) {
        return this.variable.stream().filter(v -> v.getKey().equalsIgnoreCase(key)).findFirst().orElse(null);
    }

    public List<Countdown> getCountdowns() {
        return this.countdowns;
    }

    public Countdown getCountdownByKey(String key, UUID uuid) {
        for (Countdown c : this.countdowns) {
            if (!c.getKey().equalsIgnoreCase(key) || !c.getUUID().equals(uuid)) continue;
            return c;
        }
        return null;
    }

    public boolean haveCountdownByKey(String key, UUID uuid) {
        for (Countdown c : this.countdowns) {
            if (!c.getKey().equalsIgnoreCase(key) || !c.getUUID().equals(uuid)) continue;
            return true;
        }
        return false;
    }
}

